/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.compat;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.compat.DependencyServiceLoader;
import org.jetbrains.annotations.NotNull;

public class ModDependencyServiceLoader<T>
extends DependencyServiceLoader<T> {
    private final String _modId;

    public ModDependencyServiceLoader(String modId, Class<T> service, java.util.function.Supplier<@NotNull T> fallbackFactory) {
        super(ModDependencyServiceLoader.supplier(modId, service, fallbackFactory));
        this._modId = modId;
    }

    public String getId() {
        return this._modId;
    }

    public boolean isModLoaded() {
        return CodeHelper.isModLoaded(this.getId());
    }

    private static <T> Supplier<@NotNull T> supplier(String modId, Class<T> service, java.util.function.Supplier<@NotNull T> fallbackSupplier) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)modId) ? 1 : 0) != 0, (Object)"Mod ID must not be null or empty");
        Preconditions.checkNotNull(fallbackSupplier, (Object)"Fallback factory must not be null");
        if (CodeHelper.isModLoaded(modId)) {
            return ModDependencyServiceLoader.loadOrFallback(service, fallbackSupplier);
        }
        return fallbackSupplier::get;
    }
}

