/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.compat.patchouli;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import it.zerono.mods.zerocore.ZeroCore;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.compat.Mods;
import it.zerono.mods.zerocore.lib.compat.patchouli.component.standardpage.Crafting;
import it.zerono.mods.zerocore.lib.compat.patchouli.component.standardpage.Multiblock;
import it.zerono.mods.zerocore.lib.compat.patchouli.component.standardpage.Smelting;
import it.zerono.mods.zerocore.lib.compat.patchouli.component.standardpage.Spotlight;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullSupplier;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.template.BookTemplate;

public class Patchouli {
    private static boolean s_init = false;
    private static final Map<IMultiblock, Function<BlockState, BlockState>> s_renderBlockStateMappers = Maps.newHashMap();
    private static final Map<IMultiblock, Function<BlockState, ModelData>> s_modelDataMappers = Maps.newHashMap();

    public static void registerMultiblock(ResourceLocation id, IMultiblock multiblock, Function<BlockState, BlockState> renderBlockStateMappers, Function<BlockState, ModelData> modelDataMapper) {
        PatchouliAPI.get().registerMultiblock(id, multiblock);
        s_renderBlockStateMappers.put(multiblock, renderBlockStateMappers);
        s_modelDataMappers.put(multiblock, modelDataMapper);
    }

    public static BlockState getRenderBlockStateFor(IMultiblock multiblock, BlockState blockState) {
        return s_renderBlockStateMappers.getOrDefault(multiblock, bs -> bs).apply(blockState);
    }

    public static ModelData getModelDataFor(IMultiblock multiblock, BlockState blockState) {
        return s_modelDataMappers.getOrDefault(multiblock, b -> ModelData.EMPTY).apply(blockState);
    }

    public static void initialize() {
        Mods.PATCHOULI.ifPresent((NonNullSupplier<Runnable>)((NonNullSupplier)() -> () -> {
            if (s_init) {
                return;
            }
            Log.LOGGER.info("Initializing Patchouli custom templates...");
            BookTemplate.registerComponent((ResourceLocation)ZeroCore.ROOT_LOCATION.buildWithSuffix("zcspt_multiblock"), Multiblock.class);
            BookTemplate.registerComponent((ResourceLocation)ZeroCore.ROOT_LOCATION.buildWithSuffix("zcspt_spotlight"), Spotlight.class);
            BookTemplate.registerComponent((ResourceLocation)ZeroCore.ROOT_LOCATION.buildWithSuffix("zcspt_crafting"), Crafting.class);
            BookTemplate.registerComponent((ResourceLocation)ZeroCore.ROOT_LOCATION.buildWithSuffix("zcspt_smelting"), Smelting.class);
            s_init = true;
        }));
    }

    public static void openBookEntry(ResourceLocation bookId, ResourceLocation entryId, int pageNum) {
        Preconditions.checkNotNull((Object)bookId, (Object)"Book ID must not be null");
        Preconditions.checkNotNull((Object)entryId, (Object)"Entry ID must not be null");
        Preconditions.checkArgument((pageNum >= 0 ? 1 : 0) != 0, (Object)"Page number must be positive");
        try {
            PatchouliAPI.get().openBookEntry(bookId, entryId, pageNum);
        }
        catch (Exception ex) {
            Log.LOGGER.error(Log.CORE, "Exception while opening Patchouli book.", (Throwable)ex);
        }
    }

    public static void consumeBookStack(ResourceLocation bookId, NonNullConsumer<ItemStack> consumer) {
        Mods.PATCHOULI.map(() -> PatchouliAPI.get().getBookStack(bookId)).filter(stack -> !stack.m_41619_()).ifPresent(arg_0 -> consumer.accept(arg_0));
    }
}

