/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.loot;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;

public abstract class ModBlockLootSubProvider
extends BlockLootSubProvider {
    private final Set<Block> _registeredBlocks = new ObjectOpenHashSet(128);

    protected ModBlockLootSubProvider(Set<Item> explosionResistantItems, FeatureFlagSet enabledFeatures) {
        super(explosionResistantItems, enabledFeatures);
    }

    protected void m_247577_(Block block, LootTable.Builder builder) {
        Preconditions.checkState((boolean)this._registeredBlocks.add(block), (String)"Block %s was already added to this sub provider", (Object)block);
        super.m_247577_(block, builder);
    }

    protected void add(Supplier<? extends Block> block, LootTable.Builder builder) {
        this.m_247577_(block.get(), builder);
    }

    protected void add(Supplier<? extends Block> block, Function<Block, LootTable.Builder> mapper) {
        this.m_246481_(block.get(), mapper);
    }

    protected void otherWhenSilkTouch(Supplier<? extends Block> block, Supplier<? extends Block> drop) {
        this.m_245854_(block.get(), drop.get());
    }

    protected void dropWhenSilkTouch(Supplier<? extends Block> block) {
        this.m_245644_(block.get());
    }

    @SafeVarargs
    protected final void dropWhenSilkTouch(Supplier<? extends Block> ... blocks) {
        for (Supplier<? extends Block> block : blocks) {
            this.dropWhenSilkTouch(block);
        }
    }

    protected void dropOther(Supplier<? extends Block> block, Supplier<? extends ItemLike> drop) {
        this.m_246125_(block.get(), drop.get());
    }

    protected void dropSelf(Supplier<? extends Block> block) {
        this.dropOther(block, block);
    }

    @SafeVarargs
    protected final void dropSelf(Supplier<? extends Block> ... blocks) {
        for (Supplier<? extends Block> block : blocks) {
            this.dropSelf(block);
        }
    }

    protected void dropOre(Supplier<? extends Block> ore, Supplier<? extends Item> drop) {
        this.m_246481_(ore.get(), block -> this.m_246109_((Block)block, (Item)drop.get()));
    }

    protected Iterable<Block> getKnownBlocks() {
        return this._registeredBlocks;
    }
}

