/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.Nullable;

public class BooleanData
extends AbstractData<Boolean>
implements IContainerData {
    private boolean _lastValue;

    public static BooleanData immutable(ModContainer container, boolean isClientSide, boolean value) {
        return BooleanData.of(container, isClientSide, (NonNullSupplier<Supplier<Boolean>>)((NonNullSupplier)() -> () -> value));
    }

    public static BooleanData sampled(int frequency, ModContainer container, boolean isClientSide, NonNullSupplier<Supplier<Boolean>> serverSideGetter) {
        return BooleanData.of(container, isClientSide, (NonNullSupplier<Supplier<Boolean>>)((NonNullSupplier)() -> new Sampler(frequency, serverSideGetter)));
    }

    public static BooleanData of(ModContainer container, boolean isClientSide, NonNullSupplier<Supplier<Boolean>> serverSideGetter) {
        Preconditions.checkNotNull((Object)container, (Object)"Container must not be null.");
        Preconditions.checkNotNull(serverSideGetter, (Object)"Server side getter must not be null.");
        BooleanData data = isClientSide ? new BooleanData() : new BooleanData(serverSideGetter);
        container.addBindableData(data);
        return data;
    }

    public static BooleanData of(ModContainer container, boolean isClientSide, boolean[] array, int index) {
        Preconditions.checkNotNull((Object)array, (Object)"Array must not be null.");
        Preconditions.checkArgument((index >= 0 && index < array.length ? 1 : 0) != 0, (Object)"Index must be a valid index for the array.");
        BooleanData data = BooleanData.of(container, isClientSide, (NonNullSupplier<Supplier<Boolean>>)((NonNullSupplier)() -> () -> array[index]));
        if (isClientSide) {
            data.bind(v -> {
                array[index] = v;
            });
        }
        return data;
    }

    @Override
    @Nullable
    public NonNullConsumer<FriendlyByteBuf> getContainerDataWriter() {
        boolean current = (Boolean)this._getter.get();
        if (this._lastValue != current) {
            this._lastValue = current;
            return buffer -> buffer.writeBoolean(current);
        }
        return null;
    }

    @Override
    public void readContainerData(FriendlyByteBuf dataSource) {
        this.notify(dataSource.readBoolean());
    }

    @Override
    @Nullable
    public Boolean defaultValue() {
        return Boolean.FALSE;
    }

    private BooleanData() {
    }

    private BooleanData(NonNullSupplier<Supplier<Boolean>> serverSideGetter) {
        super(serverSideGetter);
        this._lastValue = false;
    }
}

