/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.Nullable;

public class ByteData
extends AbstractData<Byte>
implements IContainerData {
    private byte _lastValue;

    public static ByteData immutable(ModContainer container, boolean isClientSide, byte value) {
        return ByteData.of(container, isClientSide, (NonNullSupplier<Supplier<Byte>>)((NonNullSupplier)() -> () -> value));
    }

    public static ByteData sampled(int frequency, ModContainer container, boolean isClientSide, NonNullSupplier<Supplier<Byte>> serverSideGetter) {
        return ByteData.of(container, isClientSide, (NonNullSupplier<Supplier<Byte>>)((NonNullSupplier)() -> new Sampler(frequency, serverSideGetter)));
    }

    public static ByteData of(ModContainer container, boolean isClientSide, NonNullSupplier<Supplier<Byte>> serverSideGetter) {
        Preconditions.checkNotNull((Object)container, (Object)"Container must not be null.");
        Preconditions.checkNotNull(serverSideGetter, (Object)"Server side getter must not be null.");
        ByteData data = isClientSide ? new ByteData() : new ByteData(serverSideGetter);
        container.addBindableData(data);
        return data;
    }

    public static ByteData of(ModContainer container, boolean isClientSide, byte[] array, int index) {
        Preconditions.checkNotNull((Object)array, (Object)"Array must not be null.");
        Preconditions.checkArgument((index >= 0 && index < array.length ? 1 : 0) != 0, (Object)"Index must be a valid index for the array.");
        ByteData data = ByteData.of(container, isClientSide, (NonNullSupplier<Supplier<Byte>>)((NonNullSupplier)() -> () -> array[index]));
        if (isClientSide) {
            data.bind(v -> {
                array[index] = v;
            });
        }
        return data;
    }

    @Override
    @Nullable
    public NonNullConsumer<FriendlyByteBuf> getContainerDataWriter() {
        byte current = (Byte)this._getter.get();
        if (this._lastValue != current) {
            this._lastValue = current;
            return buffer -> buffer.writeByte((int)current);
        }
        return null;
    }

    @Override
    public void readContainerData(FriendlyByteBuf dataSource) {
        this.notify(dataSource.readByte());
    }

    @Override
    @Nullable
    public Byte defaultValue() {
        return (byte)0;
    }

    private ByteData() {
    }

    private ByteData(NonNullSupplier<Supplier<Byte>> serverSideGetter) {
        super(serverSideGetter);
        this._lastValue = 0;
    }
}

