/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.Nullable;

public class ShortData
extends AbstractData<Short>
implements IContainerData {
    private short _lastValue;

    public static ShortData immutable(ModContainer container, boolean isClientSide, short value) {
        return ShortData.of(container, isClientSide, (NonNullSupplier<Supplier<Short>>)((NonNullSupplier)() -> () -> value));
    }

    public static ShortData sampled(int frequency, ModContainer container, boolean isClientSide, NonNullSupplier<Supplier<Short>> serverSideGetter) {
        return ShortData.of(container, isClientSide, (NonNullSupplier<Supplier<Short>>)((NonNullSupplier)() -> new Sampler(frequency, serverSideGetter)));
    }

    public static ShortData of(ModContainer container, boolean isClientSide, NonNullSupplier<Supplier<Short>> serverSideGetter) {
        Preconditions.checkNotNull((Object)container, (Object)"Container must not be null.");
        Preconditions.checkNotNull(serverSideGetter, (Object)"Server side getter must not be null.");
        ShortData data = isClientSide ? new ShortData() : new ShortData(serverSideGetter);
        container.addBindableData(data);
        return data;
    }

    public static ShortData of(ModContainer container, boolean isClientSide, short[] array, int index) {
        Preconditions.checkNotNull((Object)array, (Object)"Array must not be null.");
        Preconditions.checkArgument((index >= 0 && index < array.length ? 1 : 0) != 0, (Object)"Index must be a valid index for the array.");
        ShortData data = ShortData.of(container, isClientSide, (NonNullSupplier<Supplier<Short>>)((NonNullSupplier)() -> () -> array[index]));
        if (isClientSide) {
            data.bind(v -> {
                array[index] = v;
            });
        }
        return data;
    }

    @Override
    @Nullable
    public NonNullConsumer<FriendlyByteBuf> getContainerDataWriter() {
        short current = (Short)this._getter.get();
        if (this._lastValue != current) {
            this._lastValue = current;
            return buffer -> buffer.m_130130_((int)current);
        }
        return null;
    }

    @Override
    public void readContainerData(FriendlyByteBuf dataSource) {
        this.notify(dataSource.readShort());
    }

    @Override
    @Nullable
    public Short defaultValue() {
        return (short)0;
    }

    private ShortData() {
    }

    private ShortData(NonNullSupplier<Supplier<Short>> serverSideGetter) {
        super(serverSideGetter);
        this._lastValue = 0;
    }
}

