/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.multiblock;

import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockMachine;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.storage.IPartStorage;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.world.NeighboringPositions;
import java.util.Collections;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;

public interface IMultiblockController<Controller extends IMultiblockController<Controller>>
extends IMultiblockMachine,
IMultiblockValidator,
ISyncableEntity,
Comparable<Controller> {
    public boolean isEmpty();

    public int getPartsCount();

    default public boolean isControllerCompatible(Controller other) {
        return this.getClass().equals(other.getClass());
    }

    default public boolean isSameController(Controller other) {
        return this == other;
    }

    default public boolean isPartCompatible(IMultiblockPart<Controller> part) {
        return true;
    }

    public boolean containsPart(IMultiblockPart<Controller> var1);

    default public boolean containsPartsAt(NeighboringPositions positions) {
        return false;
    }

    default public boolean containsPartsAt(BlockPos[] positions) {
        return false;
    }

    public void attachPart(IMultiblockPart<Controller> var1);

    public void detachPart(IMultiblockPart<Controller> var1, boolean var2);

    @Deprecated
    default public Set<IMultiblockPart<Controller>> detachAllParts() {
        return Collections.emptySet();
    }

    public IPartStorage<Controller> detachAll();

    public void assimilateController(Controller var1);

    public boolean shouldConsumeController(Controller var1);

    public IPartStorage<Controller> checkForDisconnections();

    public Runnable listenForDataUpdate(Runnable var1);

    public void unlistenForDataUpdate(Runnable var1);

    public void syncFromSaveDelegate(CompoundTag var1, ISyncableEntity.SyncReason var2);

    public void checkIfMachineIsWhole();

    public boolean isAssembled();

    public boolean isDisassembled();

    public boolean isPaused();

    public void updateMultiblockEntity();

    public void recalculateCoords();

    public void forceStructureUpdate(Level var1);
}

