/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.recipe;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.recipe.ModRecipe;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.util.NonNullFunction;

public class ModRecipeType<Recipe extends ModRecipe>
implements RecipeType<Recipe> {
    private static final List<ModRecipeType<? extends ModRecipe>> s_types = Lists.newLinkedList();
    private final ResourceLocation _id;
    private List<Recipe> _cache;

    public static <Recipe extends ModRecipe> ModRecipeType<Recipe> create(ResourceLocation id) {
        ModRecipeType<Recipe> type = new ModRecipeType<Recipe>(id);
        s_types.add(type);
        return type;
    }

    public static void invalidate() {
        s_types.forEach(ModRecipeType::invalidateCache);
    }

    public static <Recipe extends ModRecipe> void onRegisterRecipes(BiConsumer<ResourceLocation, RecipeType<?>> register) {
        s_types.forEach(type -> register.accept(type._id, (RecipeType<?>)type));
    }

    public List<Recipe> getRecipes() {
        RecipeManager manager;
        if (this._cache.isEmpty() && null != (manager = CodeHelper.getRecipeManager())) {
            this._cache = ObjectLists.unmodifiable((ObjectList)new ObjectArrayList((Collection)manager.m_44013_((RecipeType)this)));
        }
        return this._cache;
    }

    public List<Recipe> getRecipes(Predicate<Recipe> filter) {
        return this.stream().filter(filter).collect(Collectors.toList());
    }

    public <R extends Recipe> List<R> getRecipes(Predicate<Recipe> filter, NonNullFunction<Recipe, R> mapping) {
        return this.stream().filter(filter).map(arg_0 -> mapping.apply(arg_0)).collect(Collectors.toList());
    }

    public Stream<Recipe> stream() {
        return this.getRecipes().stream();
    }

    public Optional<Recipe> findFirst(Predicate<Recipe> predicate) {
        return this.stream().filter(predicate).findFirst();
    }

    public boolean contains(Predicate<Recipe> predicate) {
        return this.stream().anyMatch(predicate);
    }

    public String toString() {
        return this._id.toString();
    }

    protected ModRecipeType(ResourceLocation id) {
        this._id = id;
        this._cache = Collections.emptyList();
    }

    protected void invalidateCache() {
        this._cache = Collections.emptyList();
    }
}

