/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.tag;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.common.util.NonNullSupplier;

public class TagSource<T> {
    private final NonNullSupplier<Registry<T>> _registry;

    public TagSource(NonNullSupplier<Registry<T>> registrySupplier) {
        this._registry = registrySupplier;
    }

    public TagKey<T> createKey(ResourceLocation id) {
        return TagKey.m_203882_((ResourceKey)((Registry)this._registry.get()).m_123023_(), (ResourceLocation)id);
    }

    public TagKey<T> createKey(String id) {
        return this.createKey(new ResourceLocation(id));
    }

    public TagKey<T> createKey(String id, NonNullFunction<String, ResourceLocation> factory) {
        return this.createKey((ResourceLocation)factory.apply((Object)id));
    }

    public boolean isTagged(T object, TagKey<T> tagKey) {
        Registry registry = (Registry)this._registry.get();
        return registry.m_7854_(object).map(arg_0 -> ((Registry)registry).m_246971_(arg_0)).map(holder -> holder.m_203656_(tagKey)).orElse(false);
    }

    public boolean exist(TagKey<T> tagKey) {
        return ((Registry)this._registry.get()).m_203431_(tagKey).isPresent();
    }

    public boolean existWithContent(TagKey<T> tagKey) {
        return this.getObjects(tagKey).size() > 0;
    }

    public List<T> getObjects(TagKey<T> tagKey) {
        LinkedList list = new LinkedList();
        ((Registry)this._registry.get()).m_206058_(tagKey).forEach(holder -> list.add(holder.m_203334_()));
        return list.isEmpty() ? ObjectLists.emptyList() : ObjectLists.unmodifiable((ObjectList)new ObjectArrayList(list));
    }

    public Optional<T> getFirstObject(TagKey<T> tagKey) {
        List<T> objects = this.getObjects(tagKey);
        return objects.isEmpty() ? Optional.empty() : Optional.ofNullable(objects.get(0));
    }

    public List<TagKey<T>> getTags(T object) {
        Registry registry = (Registry)this._registry.get();
        List list = registry.m_7854_(object).map(arg_0 -> ((Registry)registry).m_246971_(arg_0)).map(Holder::m_203616_).map(s -> s.collect(Collectors.toList())).orElse(Collections.emptyList());
        return list.isEmpty() ? ObjectLists.emptyList() : ObjectLists.unmodifiable((ObjectList)new ObjectArrayList(list));
    }
}

