/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc.maptrades;

import com.telepathicgrunt.repurposedstructures.misc.maptrades.MerchantMapUpdating;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import org.jetbrains.annotations.Nullable;

public class StructureSpecificMaps {

    public static class TreasureMapForEmeralds
    implements VillagerTrades.ItemListing {
        private final int emeraldCost;
        private final ResourceKey<Structure> destination;
        private final TagKey<Structure> destinationTag;
        private final String displayName;
        private final MapDecoration.Type destinationType;
        private final int maxUses;
        private final int villagerXp;
        private final int spawnRegionSearchRadius;

        public TreasureMapForEmeralds(int emeraldCost, String csf, String displayName, MapDecoration.Type mapIcon, int maxUse, int xp, int spawnRegionSearchRadius) {
            this.emeraldCost = emeraldCost;
            if (csf.startsWith("#")) {
                this.destination = null;
                this.destinationTag = TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation(csf.replaceFirst("#", "")));
            } else {
                this.destination = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation(csf));
                this.destinationTag = null;
            }
            this.displayName = displayName;
            this.destinationType = mapIcon;
            this.maxUses = maxUse;
            this.villagerXp = xp;
            this.spawnRegionSearchRadius = spawnRegionSearchRadius;
        }

        @Nullable
        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            Level level = entity.m_9236_();
            if (!(level instanceof ServerLevel)) {
                return null;
            }
            ServerLevel serverlevel = (ServerLevel)level;
            return this.getOffer(serverlevel, entity);
        }

        private HolderSet<Structure> getHolderSet(ServerLevel level) {
            Registry registry = level.m_9598_().m_175515_(Registries.f_256944_);
            return HolderSet.m_205809_((Holder[])new Holder[]{registry.m_246971_(this.destination)});
        }

        private boolean mapValid(ServerLevel level) {
            HolderSet holderSet;
            if (this.destinationTag == null) {
                holderSet = this.getHolderSet(level);
            } else {
                Optional optionalHolders = level.m_9598_().m_175515_(Registries.f_256944_).m_203431_(this.destinationTag);
                if (optionalHolders.isEmpty()) {
                    return false;
                }
                holderSet = (HolderSet)optionalHolders.get();
            }
            boolean isValidSpawning = true;
            for (Holder structureHolder : holderSet) {
                if (level.m_7726_().m_255415_().m_255260_(structureHolder).isEmpty()) {
                    isValidSpawning = false;
                    break;
                }
                if (!level.m_7726_().m_8481_().m_62218_().m_207840_().stream().noneMatch(e -> ((Structure)structureHolder.m_203334_()).m_226559_().m_203333_(e))) continue;
                isValidSpawning = false;
                break;
            }
            return isValidSpawning;
        }

        private MerchantOffer getOffer(ServerLevel level, Entity entity) {
            if (!this.mapValid(level)) {
                return null;
            }
            if (this.destinationTag == null) {
                HolderSet<Structure> holderSet = this.getHolderSet(level);
                return MerchantMapUpdating.updateMapAsync(entity, this.emeraldCost, this.displayName, this.destinationType, this.maxUses, this.villagerXp, holderSet, this.spawnRegionSearchRadius);
            }
            return MerchantMapUpdating.updateMapAsync(entity, this.emeraldCost, this.displayName, this.destinationType, this.maxUses, this.villagerXp, this.destinationTag, this.spawnRegionSearchRadius);
        }
    }
}

