/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableSet;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import quek.undergarden.entity.animal.Brute;

public class BruteModel<T extends Brute>
extends AgeableListModel<T> {
    private final ModelPart head;
    private final ModelPart torso;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public BruteModel(ModelPart root) {
        this.torso = root.m_171324_("uppertorso");
        this.head = root.m_171324_("head");
        this.leftArm = root.m_171324_("leftarm");
        this.rightArm = root.m_171324_("rightarm");
        this.leftLeg = root.m_171324_("leftleg");
        this.rightLeg = root.m_171324_("rightleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition uppertorso = partdefinition.m_171599_("uppertorso", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-7.0f, -7.5f, -4.0f, 14.0f, 15.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(36, 37).m_171488_(0.0f, -10.5f, 1.0f, 0.0f, 18.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.5f, (float)1.0f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition lowertorso = uppertorso.m_171599_("lowertorso", CubeListBuilder.m_171558_().m_171514_(36, 29).m_171488_(-6.0f, -5.9973f, -2.76f, 12.0f, 12.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(46, 60).m_171488_(0.0f, -5.9973f, 2.24f, 0.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)10.4973f, (float)-1.24f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(36, 14).m_171488_(-5.0f, -6.0f, -8.0f, 10.0f, 6.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(44, 0).m_171488_(-3.0f, 0.0f, -8.0f, 6.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition horns = head.m_171599_("horns", CubeListBuilder.m_171558_().m_171514_(62, 57).m_171488_(-5.5f, -2.0f, -3.0f, 2.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(16, 58).m_171488_(3.5f, -2.0f, -3.0f, 2.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-6.0f, (float)1.2217f, (float)0.0f, (float)0.0f));
        PartDefinition horns2 = horns.m_171599_("horns2", CubeListBuilder.m_171558_().m_171514_(30, 64).m_171488_(-5.5f, 1.0f, -5.0f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(36, 0).m_171488_(3.5f, 1.0f, -5.0f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-2.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition leftarm = partdefinition.m_171599_("leftarm", CubeListBuilder.m_171558_().m_171514_(18, 23).m_171488_(0.0f, -4.0f, -3.0f, 4.0f, 30.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)7.0f, (float)-2.0f, (float)-1.0f));
        PartDefinition rightarm = partdefinition.m_171599_("rightarm", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171488_(-4.0f, -4.0f, -3.0f, 4.0f, 30.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-7.0f, (float)-2.0f, (float)-1.0f));
        PartDefinition leftleg = partdefinition.m_171599_("leftleg", CubeListBuilder.m_171558_().m_171514_(0, 58).m_171488_(-1.8f, -1.0f, -2.0f, 4.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)10.0f, (float)10.0f));
        PartDefinition rightleg = partdefinition.m_171599_("rightleg", CubeListBuilder.m_171558_().m_171514_(54, 46).m_171488_(-2.2f, -1.0f, -2.0f, 4.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)10.0f, (float)10.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableSet.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableSet.of((Object)this.head, (Object)this.torso, (Object)this.leftArm, (Object)this.rightArm, (Object)this.leftLeg, (Object)this.rightLeg, (Object[])new ModelPart[0]);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
    }
}

