/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableSet;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import quek.undergarden.entity.cavern.Nargoyle;

public class NargoyleModel<T extends Nargoyle>
extends ListModel<T> {
    private final ModelPart body;
    private final ModelPart upperBody;
    private final ModelPart lowerBody;
    private final ModelPart head;
    private final ModelPart arms;
    private final ModelPart legs;
    private final ModelPart jaw;

    public NargoyleModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.upperBody = this.body.m_171324_("upperbody");
        this.lowerBody = this.body.m_171324_("lowerbody");
        this.head = this.upperBody.m_171324_("head");
        this.arms = this.upperBody.m_171324_("arms");
        this.legs = this.lowerBody.m_171324_("legs");
        this.jaw = this.head.m_171324_("jaw");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)-3.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition upperbody = body.m_171599_("upperbody", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -11.0f, 0.0f, 10.0f, 11.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)6.0f, (float)4.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition head = upperbody.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(42, 51).m_171488_(-4.0f, -9.5f, -2.0f, 8.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(16, 28).m_171488_(-3.0f, -8.5f, -4.0f, 6.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(45, 49).m_171488_(-2.0f, -9.5f, 1.0f, 4.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-10.5f, (float)3.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition jaw = head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(34, 35).m_171488_(-4.0f, -7.5f, -1.0f, 8.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(26, 0).m_171488_(-2.0f, -6.5f, 0.0f, 4.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-2.0f));
        PartDefinition ear1 = head.m_171599_("ear1", CubeListBuilder.m_171558_().m_171514_(0, 54).m_171488_(-5.0f, -1.0f, -1.0f, 3.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition ear2 = head.m_171599_("ear2", CubeListBuilder.m_171558_().m_171514_(0, 54).m_171480_().m_171488_(-1.5f, 0.0f, -6.0f, 3.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)3.5f, (float)-1.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition arms = upperbody.m_171599_("arms", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-7.4927f, (float)3.3309f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition upperarmleft = arms.m_171599_("upperarmleft", CubeListBuilder.m_171558_().m_171514_(34, 0).m_171488_(5.0f, -9.9927f, -0.9691f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.0073f, (float)-0.0309f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition lowerarmleft = upperarmleft.m_171599_("lowerarmleft", CubeListBuilder.m_171558_().m_171514_(34, 43).m_171488_(-1.5f, -14.7194f, -1.2086f, 2.0f, 16.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)7.0f, (float)-9.9927f, (float)1.0309f, (float)-1.1345f, (float)0.0f, (float)0.0f));
        PartDefinition upperarmright = arms.m_171599_("upperarmright", CubeListBuilder.m_171558_().m_171514_(34, 0).m_171480_().m_171488_(-8.0f, -9.9927f, -0.6691f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-0.0073f, (float)-0.3309f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition lowerarmright = upperarmright.m_171599_("lowerarmright", CubeListBuilder.m_171558_().m_171514_(34, 43).m_171480_().m_171488_(-0.5f, -14.7194f, -1.2086f, 2.0f, 16.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-7.0f, (float)-9.9927f, (float)1.3309f, (float)-1.1345f, (float)0.0f, (float)0.0f));
        PartDefinition lowerbody = body.m_171599_("lowerbody", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)5.0f, (float)-1.2217f, (float)0.0f, (float)0.0f));
        PartDefinition hips = lowerbody.m_171599_("hips", CubeListBuilder.m_171558_().m_171514_(21, 21).m_171488_(-3.0f, -4.0f, 2.0f, 6.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.7189f, (float)-1.2679f, (float)0.48f, (float)0.0f, (float)0.0f));
        PartDefinition legs = lowerbody.m_171599_("legs", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-2.527f, (float)6.4479f, (float)-1.7017f, (float)0.0f, (float)0.0f));
        PartDefinition upperrightleg = legs.m_171599_("upperrightleg", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171480_().m_171488_(-5.0f, -9.027f, -1.0521f, 2.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.027f, (float)-0.9479f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition lowerrightleg = upperrightleg.m_171599_("lowerrightleg", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(-1.5f, -8.8618f, -0.8628f, 1.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)-8.2609f, (float)-0.6949f, (float)1.2217f, (float)0.0f, (float)0.0f));
        PartDefinition upperleftleg = legs.m_171599_("upperleftleg", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(3.0f, -9.027f, -1.0521f, 2.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.027f, (float)-0.9479f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition lowerleftleg = upperleftleg.m_171599_("lowerleftleg", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(0.5f, -8.8618f, -0.8628f, 1.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-8.2609f, (float)-0.6949f, (float)1.2217f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104205_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104203_ = 0.4363f + headPitch * ((float)Math.PI / 180);
        this.arms.f_104203_ = 1.5708f + Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.legs.f_104203_ = -1.7017f + -(Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount);
        this.jaw.f_104203_ = entity.m_5912_() ? 0.3491f : 0.0f;
    }

    public Iterable<ModelPart> m_6195_() {
        return ImmutableSet.of((Object)this.body);
    }
}

