/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import quek.undergarden.entity.projectile.MinionProjectile;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGSoundEvents;
import quek.undergarden.registry.UGTags;

public class Minion
extends AbstractGolem
implements RangedAttackMob {
    public Minion(EntityType<? extends AbstractGolem> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 0.5, 20, 10.0f));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, entity -> entity.m_6095_() != UGEntityTypes.STONEBORN.get() && entity instanceof Enemy || entity.m_6095_().m_204039_(UGTags.Entities.ROTSPAWN) || entity.m_6095_().m_204039_(UGTags.Entities.CAVERN_CREATURE)));
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 1.0f;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return AbstractGolem.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22285_, 5.0).m_22268_(Attributes.f_22279_, 0.3);
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UGSoundEvents.MINION_DEATH.get();
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        MinionProjectile projectile = new MinionProjectile(this.m_9236_(), (LivingEntity)this);
        double xDistance = target.m_20185_() - this.m_20185_();
        double yDistance = target.m_20227_(0.3333333333333333) - projectile.m_20186_();
        double zDistance = target.m_20189_() - this.m_20189_();
        double yMath = Mth.m_14116_((float)((float)(xDistance * xDistance + zDistance * zDistance)));
        projectile.m_6686_(xDistance, yDistance + yMath * 0.1, zDistance, 1.6f, 1.0f);
        this.m_5496_((SoundEvent)UGSoundEvents.MINION_SHOOT.get(), 1.0f, this.m_6100_());
        this.m_9236_().m_7967_((Entity)projectile);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item != UGItems.FORGOTTEN_NUGGET.get()) {
            return InteractionResult.PASS;
        }
        float health = this.m_21223_();
        this.m_5634_(5.0f);
        if (this.m_21223_() == health) {
            return InteractionResult.PASS;
        }
        this.m_5496_((SoundEvent)UGSoundEvents.MINION_REPAIR.get(), 1.0f, 2.0f);
        if (!player.m_150110_().f_35937_) {
            itemstack.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    public boolean m_6040_() {
        return true;
    }
}

