/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import quek.undergarden.entity.rotspawn.RotspawnMonster;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGEffects;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGParticleTypes;
import quek.undergarden.registry.UGSoundEvents;

public class Gloomper
extends Animal {
    private int jumpTicks;
    private int jumpDuration;
    private boolean wasOnGround;
    private int currentMoveTypeDuration;

    public Gloomper(EntityType<? extends Animal> type, Level level) {
        super(type, level);
        this.f_21343_ = new JumpHelperController(this);
        this.f_21342_ = new MoveHelperController(this);
        this.setMovementSpeed(0.0);
        this.m_274367_(1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 2.5));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, RotspawnMonster.class, 12.0f, 2.0, 2.5));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)UGBlocks.GLOOMGOURD.get()}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.3);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UGSoundEvents.GLOOMPER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)UGSoundEvents.GLOOMPER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UGSoundEvents.GLOOMPER_DEATH.get();
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)UGEntityTypes.GLOOMPER.get()).m_20615_(this.m_9236_());
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6898_(ItemStack stack) {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)UGBlocks.GLOOMGOURD.get()}).test(stack);
    }

    protected float m_6118_() {
        if (!(this.f_19862_ || this.m_21566_().m_24995_() && this.m_21566_().m_25001_() > this.m_20186_() + 0.5)) {
            Vec3 vector3d;
            Path path = this.m_21573_().m_26570_();
            if (path != null && !path.m_77392_() && (vector3d = path.m_77380_((Entity)this)).m_7098_() > this.m_20186_() + 0.5) {
                return 0.5f;
            }
            return this.m_21566_().m_24999_() <= 0.6 ? 0.2f : 0.3f;
        }
        return 0.5f;
    }

    protected void m_6135_() {
        double d1;
        super.m_6135_();
        double d0 = this.m_21566_().m_24999_();
        if (d0 > 0.0 && (d1 = this.m_20184_().m_165925_()) < 0.01) {
            this.m_19920_(0.1f, new Vec3(0.0, 0.0, 1.0));
        }
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)1);
        }
    }

    public float getJumpCompletion(float delta) {
        return this.jumpDuration == 0 ? 0.0f : ((float)this.jumpTicks + delta) / (float)this.jumpDuration;
    }

    public void setMovementSpeed(double newSpeed) {
        this.m_21573_().m_26517_(newSpeed);
        this.m_21566_().m_6849_(this.m_21566_().m_25000_(), this.m_21566_().m_25001_(), this.m_21566_().m_25002_(), newSpeed);
    }

    public void m_6862_(boolean jumping) {
        super.m_6862_(jumping);
        if (jumping && !this.m_20069_() && !this.f_19798_) {
            this.m_5496_((SoundEvent)UGSoundEvents.GLOOMPER_HOP.get(), this.m_6121_(), ((this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    public void startJumping() {
        this.m_6862_(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    public void m_8024_() {
        if (this.currentMoveTypeDuration > 0) {
            --this.currentMoveTypeDuration;
        }
        if (this.m_20096_()) {
            JumpHelperController jumpController;
            if (!this.wasOnGround) {
                this.m_6862_(false);
                this.checkLandingDelay();
            }
            if (!(jumpController = (JumpHelperController)this.f_21343_).isJumping()) {
                if (this.f_21342_.m_24995_() && this.currentMoveTypeDuration == 0) {
                    Path path = this.f_21344_.m_26570_();
                    Vec3 vector3d = new Vec3(this.m_21566_().m_25000_(), this.m_21566_().m_25001_(), this.m_21566_().m_25002_());
                    if (path != null && !path.m_77392_()) {
                        vector3d = path.m_77380_((Entity)this);
                    }
                    this.calculateRotationYaw(vector3d.m_7096_(), vector3d.m_7094_());
                    this.startJumping();
                }
            } else if (!jumpController.canJump()) {
                this.enableJumpControl();
            }
        }
        this.wasOnGround = this.m_20096_();
    }

    public boolean m_5843_() {
        return false;
    }

    private void calculateRotationYaw(double x, double z) {
        this.m_146922_((float)(Mth.m_14136_((double)(z - this.m_20189_()), (double)(x - this.m_20185_())) * 57.2957763671875) - 90.0f);
    }

    private void enableJumpControl() {
        ((JumpHelperController)this.m_21569_()).setCanJump(true);
    }

    private void disableJumpControl() {
        ((JumpHelperController)this.m_21569_()).setCanJump(false);
    }

    private void updateMoveTypeDuration() {
        this.currentMoveTypeDuration = this.m_21566_().m_24999_() < 2.2 ? 10 : 1;
    }

    private void checkLandingDelay() {
        this.updateMoveTypeDuration();
        this.disableJumpControl();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.m_6862_(false);
        }
    }

    public void m_7822_(byte id) {
        if (id == 1) {
            this.m_20076_();
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        } else {
            super.m_7822_(id);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_((Item)UGItems.GLOOMPER_ANTHEM_DISC.get()) && this.m_6084_()) {
            if (!this.m_9236_().m_5776_()) {
                this.m_19998_((ItemLike)UGItems.GLOOMPER_SECRET_DISC.get());
                this.m_6074_();
            }
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        AreaEffectCloud cloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        cloud.m_19724_((ParticleOptions)UGParticleTypes.GLOOMPER_FART.get());
        cloud.m_19712_(3.0f);
        cloud.m_19732_(-0.5f);
        cloud.m_19740_(10);
        cloud.m_19738_(-cloud.m_19743_() / (float)cloud.m_19748_());
        cloud.m_19716_(new MobEffectInstance((MobEffect)UGEffects.VIRULENCE.get(), 100, 0));
        if (this.m_217043_().m_188503_(2) == 0) {
            this.m_5496_((SoundEvent)UGSoundEvents.GLOOMPER_FART.get(), 1.0f, 1.0f);
            this.m_9236_().m_7967_((Entity)cloud);
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        MobEffect effect = effectInstance.m_19544_();
        if (effect == UGEffects.VIRULENCE.get()) {
            return false;
        }
        return super.m_7301_(effectInstance);
    }

    public static class JumpHelperController
    extends JumpControl {
        private final Gloomper gloomper;
        private boolean canJump;

        public JumpHelperController(Gloomper gloomper) {
            super((Mob)gloomper);
            this.gloomper = gloomper;
        }

        public boolean isJumping() {
            return this.f_24897_;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean canJumpIn) {
            this.canJump = canJumpIn;
        }

        public void m_8124_() {
            if (this.isJumping()) {
                this.gloomper.startJumping();
                this.f_24897_ = false;
            }
        }
    }

    static class MoveHelperController
    extends MoveControl {
        private final Gloomper gloomper;
        private double nextJumpSpeed;

        public MoveHelperController(Gloomper gloomper) {
            super((Mob)gloomper);
            this.gloomper = gloomper;
        }

        public void m_8126_() {
            if (this.gloomper.m_20096_() && !this.gloomper.f_20899_ && !((JumpHelperController)this.gloomper.m_21569_()).isJumping()) {
                this.gloomper.setMovementSpeed(0.0);
            } else if (this.m_24995_()) {
                this.gloomper.setMovementSpeed(this.nextJumpSpeed);
            }
            super.m_8126_();
        }

        public void m_6849_(double x, double y, double z, double speed) {
            if (this.gloomper.m_20069_()) {
                speed = 1.5;
            }
            super.m_6849_(x, y, z, speed);
            if (speed > 0.0) {
                this.nextJumpSpeed = speed;
            }
        }
    }
}

