/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.worldgen.treedecorators;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tristankechlo.explorations.init.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class CaveVineDecorator
extends TreeDecorator {
    public static final Codec<CaveVineDecorator> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("start_chance").forGetter(decorator -> Float.valueOf(decorator.startProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("berry_chance").forGetter(decorator -> Float.valueOf(decorator.berrySpawnChance)), (App)Codec.intRange((int)0, (int)10).optionalFieldOf("max_vine_length", (Object)4).forGetter(decorator -> decorator.maxVineLength), (App)Codec.BOOL.optionalFieldOf("only_outer_leaves", (Object)true).forGetter(decorator -> decorator.onlyOuterLeaves)).apply((Applicative)builder, CaveVineDecorator::new));
    private final float startProbability;
    private final float berrySpawnChance;
    private final int maxVineLength;
    private final boolean onlyOuterLeaves;

    public CaveVineDecorator(float startProbability, float berrySpawnChance, int maxVineLength, boolean onlyOuterLeaves) {
        this.startProbability = startProbability;
        this.berrySpawnChance = berrySpawnChance;
        this.maxVineLength = maxVineLength;
        this.onlyOuterLeaves = onlyOuterLeaves;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return ModRegistry.CAVE_VINES.get();
    }

    public void m_214187_(TreeDecorator.Context context) {
        RandomSource random = context.m_226067_();
        context.m_226069_().forEach(blockPosLeave -> {
            if (random.m_188501_() < this.startProbability) {
                if (this.onlyOuterLeaves && !CaveVineDecorator.isOuterBlock(blockPosLeave, context)) {
                    return;
                }
                BlockPos pos = blockPosLeave.m_7495_();
                if (context.m_226059_(pos)) {
                    CaveVineDecorator.addCaveVines(pos, context, this.berrySpawnChance, this.maxVineLength);
                }
            }
        });
    }

    private static boolean isOuterBlock(BlockPos startPos, TreeDecorator.Context context) {
        ImmutableList neighbours = ImmutableList.of((Object)startPos.m_122012_(), (Object)startPos.m_122029_(), (Object)startPos.m_122019_(), (Object)startPos.m_122024_());
        for (BlockPos pos : neighbours) {
            if (!context.m_226059_(pos)) continue;
            return true;
        }
        return false;
    }

    private static void addCaveVines(BlockPos startPos, TreeDecorator.Context context, float berryChance, int maxVineLength) {
        RandomSource random = context.m_226067_();
        BlockPos blockpos = startPos;
        for (int i = maxVineLength; context.m_226059_(blockpos) && i > 0; --i) {
            BlockState state = Blocks.f_152538_.m_49966_();
            if (random.m_188501_() < berryChance) {
                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_155977_, (Comparable)Boolean.TRUE);
            }
            context.m_226061_(blockpos, state);
            blockpos = blockpos.m_7495_();
        }
    }
}

