/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui;

import com.ldtteam.blockui.Color;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.mod.item.BlockStateRenderingData;
import com.ldtteam.blockui.util.SingleBlockGetter;
import com.ldtteam.blockui.util.cursor.Cursor;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class BOGuiGraphics
extends GuiGraphics {
    private static final SingleBlockGetter.SingleBlockNeighborhood NEIGHBORHOOD = new SingleBlockGetter.SingleBlockNeighborhood();
    private int cursorMaxDepth = -1;
    private Cursor selectedCursor = Cursor.DEFAULT;

    public BOGuiGraphics(Minecraft mc, PoseStack ps, MultiBufferSource.BufferSource buffers) {
        super(mc, ps, buffers);
    }

    private Font getFont(@Nullable ItemStack itemStack) {
        Font font;
        if (itemStack != null && (font = IClientItemExtensions.of((ItemStack)itemStack).getFont(itemStack, IClientItemExtensions.FontContext.ITEM_COUNT)) != null) {
            return font;
        }
        return this.f_279544_.f_91062_;
    }

    public void renderItemDecorations(ItemStack itemStack, int x, int y) {
        super.m_280370_(this.getFont(itemStack), itemStack, x, y);
    }

    public void renderItemDecorations(ItemStack itemStack, int x, int y, @Nullable String altStackSize) {
        super.m_280302_(this.getFont(itemStack), itemStack, x, y, altStackSize);
    }

    public int drawString(String text, float x, float y, int color) {
        return this.drawString(text, x, y, color, false);
    }

    public int drawString(String text, float x, float y, int color, boolean shadow) {
        return super.drawString(this.f_279544_.f_91062_, text, x, y, color, shadow);
    }

    public void setCursor(Cursor cursor) {
        if (this.m_280168_().f_85834_.size() >= this.cursorMaxDepth) {
            this.cursorMaxDepth = this.m_280168_().f_85834_.size();
            this.selectedCursor = cursor;
        }
    }

    public void applyCursor(int debugXoffset) {
        this.selectedCursor.apply();
        if (Pane.debugging) {
            String string = this.selectedCursor.toString();
            float f = debugXoffset;
            Objects.requireNonNull(this.f_279544_.f_91062_);
            this.drawString(string, f, -9, Color.getByName("white"));
        }
    }

    public void renderBlockStateAsItem(BlockStateRenderingData data, ItemStack itemStack) {
        FluidState fluidState;
        BakedModel itemModel = this.f_279544_.m_91291_().m_174264_(itemStack, null, null, 0);
        if (!itemModel.m_7539_() || data.blockState().m_60799_() == RenderShape.INVISIBLE) {
            itemModel = this.f_279544_.m_91291_().m_174264_(new ItemStack((ItemLike)Blocks.f_50069_), null, null, 0);
        }
        this.m_280168_().m_85836_();
        this.m_280168_().m_252880_(8.0f, 8.0f, 150.0f);
        this.m_280168_().m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        this.m_280168_().m_85841_(16.0f, 16.0f, 16.0f);
        ForgeHooksClient.handleCameraTransforms((PoseStack)this.m_280168_(), (BakedModel)itemModel, (ItemDisplayContext)ItemDisplayContext.GUI, (boolean)false);
        if (data.modelNeedsRotationFix()) {
            this.m_280168_().m_85836_();
            this.m_280168_().m_272245_(Axis.f_252436_.m_252977_(45.0f), 0.0f, 0.5f, 0.0f);
        }
        this.m_280168_().m_252880_(-0.5f, -0.5f, -0.5f);
        RenderSystem.getModelViewStack().m_85836_();
        this.applyPoseToShader();
        if (data.modelNeedsRotationFix()) {
            Lighting.m_252756_((Matrix4f)new Matrix4f().rotationAround((Quaternionfc)Axis.f_252403_.m_252977_(-180.0f), 0.5f, 0.0f, 0.5f));
        } else {
            Lighting.m_252756_((Matrix4f)new Matrix4f().rotationAround((Quaternionfc)Axis.f_252436_.m_252977_(-45.0f), 0.0f, 0.5f, 0.0f));
        }
        PoseStack poseStack = new PoseStack();
        int light = LightTexture.m_109885_((int)10, (int)10);
        this.f_279544_.m_91289_().renderSingleBlock(data.blockState(), poseStack, (MultiBufferSource)this.m_280091_(), light, OverlayTexture.f_118083_, data.modelData(), null);
        if (data.blockEntity() != null) {
            try {
                this.f_279544_.m_167982_().m_112265_(data.blockEntity()).m_6922_(data.blockEntity(), 0.0f, poseStack, (MultiBufferSource)this.m_280091_(), light, OverlayTexture.f_118083_);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_280262_();
        if (data.modelNeedsRotationFix()) {
            this.m_280168_().m_85849_();
            this.m_280168_().m_252880_(-0.5f, -0.5f, -0.5f);
            this.applyPoseToShader();
        }
        if (!(fluidState = data.blockState().m_60819_()).m_76178_()) {
            RenderType renderType = ItemBlockRenderTypes.m_109287_((FluidState)fluidState);
            BOGuiGraphics.NEIGHBORHOOD.blockState = data.blockState();
            this.f_279544_.m_91289_().m_234363_(BlockPos.f_121853_, (BlockAndTintGetter)NEIGHBORHOOD, this.m_280091_().m_6299_(renderType), data.blockState(), fluidState);
            this.m_280091_().m_109912_(renderType);
        }
        Lighting.m_84931_();
        RenderSystem.getModelViewStack().m_85849_();
        RenderSystem.applyModelViewMatrix();
        this.m_280168_().m_85849_();
    }

    public void applyPoseToShader() {
        RenderSystem.getModelViewStack().m_166856_();
        RenderSystem.getModelViewStack().m_252931_(this.m_280168_().m_85850_().m_252922_());
        RenderSystem.applyModelViewMatrix();
    }
}

