/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.customslots.example;

import com.google.common.collect.ImmutableList;
import dev.gigaherz.toolbelt.customslots.IExtensionContainer;
import dev.gigaherz.toolbelt.customslots.IExtensionSlot;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class VanillaLivingEquipment
implements IExtensionContainer {
    public static final ResourceLocation HEAD = new ResourceLocation("minecraft", EquipmentSlot.HEAD.m_20751_());
    public static final ResourceLocation CHEST = new ResourceLocation("minecraft", EquipmentSlot.CHEST.m_20751_());
    public static final ResourceLocation LEGS = new ResourceLocation("minecraft", EquipmentSlot.LEGS.m_20751_());
    public static final ResourceLocation FEET = new ResourceLocation("minecraft", EquipmentSlot.FEET.m_20751_());
    public static final ResourceLocation OFFHAND = new ResourceLocation("minecraft", EquipmentSlot.OFFHAND.m_20751_());
    public static final ResourceLocation MAINHAND = new ResourceLocation("minecraft", EquipmentSlot.MAINHAND.m_20751_());
    private final LivingEntity owner;
    private final ImmutableList<IExtensionSlot> slots = ImmutableList.of((Object)new Slot(HEAD, EquipmentSlot.HEAD), (Object)new Slot(CHEST, EquipmentSlot.CHEST), (Object)new Slot(LEGS, EquipmentSlot.LEGS), (Object)new Slot(FEET, EquipmentSlot.FEET), (Object)new Slot(OFFHAND, EquipmentSlot.OFFHAND), (Object)new Slot(MAINHAND, EquipmentSlot.MAINHAND));

    public VanillaLivingEquipment(LivingEntity owner) {
        this.owner = owner;
    }

    @Override
    @Nonnull
    public ImmutableList<IExtensionSlot> getSlots() {
        return this.slots;
    }

    @Override
    public void onContentsChanged(IExtensionSlot slot) {
    }

    @Override
    @Nonnull
    public LivingEntity getOwner() {
        return this.owner;
    }

    private class Slot
    implements IExtensionSlot {
        private final ResourceLocation id;
        private final EquipmentSlot slot;

        private Slot(ResourceLocation id, EquipmentSlot slot) {
            this.id = id;
            this.slot = slot;
        }

        @Override
        @Nonnull
        public IExtensionContainer getContainer() {
            return VanillaLivingEquipment.this;
        }

        @Override
        @Nonnull
        public ResourceLocation getType() {
            return this.id;
        }

        @Override
        @Nonnull
        public ItemStack getContents() {
            return VanillaLivingEquipment.this.owner.m_6844_(this.slot);
        }

        @Override
        public void setContents(@Nonnull ItemStack stack) {
            VanillaLivingEquipment.this.owner.m_8061_(this.slot, stack);
        }

        @Override
        public void onContentsChanged() {
            VanillaLivingEquipment.this.onContentsChanged(this);
        }

        @Override
        public boolean canEquip(@Nonnull ItemStack stack) {
            if (stack.m_41720_().canEquip(stack, this.slot, (Entity)VanillaLivingEquipment.this.owner)) {
                return true;
            }
            return IExtensionSlot.super.canEquip(stack);
        }
    }
}

