/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.ars_creo.common;

import com.hollingsworth.arsnouveau.api.potion.PotionData;
import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import com.simibubi.create.AllFluids;
import com.simibubi.create.content.fluids.potion.PotionFluid;
import com.simibubi.create.content.fluids.potion.PotionFluidHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class PotionTank
extends FluidTank {
    public static final double POTION_TO_MB = 2.5;
    public static final double MB_TO_POTION = 0.4;
    private final PotionJarTile jar;

    public PotionTank(PotionJarTile tile) {
        super((int)((double)tile.getMaxFill() * 2.5), stack -> stack.getFluid().m_6212_((Fluid)AllFluids.POTION.getSource()));
        this.jar = tile;
    }

    public boolean isFluidValid(FluidStack stack) {
        return super.isFluidValid(stack) && this.jar.canAccept(PotionData.fromTag((CompoundTag)stack.getTag()), 1);
    }

    @NotNull
    public FluidStack getFluid() {
        return PotionFluidHandler.getFluidFromPotion((Potion)this.jar.getData().getPotion(), (PotionFluid.BottleType)PotionFluid.BottleType.REGULAR, (int)this.getFluidAmount());
    }

    public boolean isEmpty() {
        return this.jar.getData().isEmpty();
    }

    public int getFluidAmount() {
        return (int)((double)this.jar.getAmount() * 2.5);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0;
        }
        PotionData data = PotionData.fromTag((CompoundTag)resource.getTag());
        if (action.simulate()) {
            if (this.jar.getData().isEmpty()) {
                return Math.min(this.capacity, resource.getAmount());
            }
            if (!data.areSameEffects(this.jar.getData())) {
                return 0;
            }
            return Math.min(this.capacity - this.getFluidAmount(), resource.getAmount());
        }
        if (this.jar.getData().isEmpty()) {
            int amountToAdd = Mth.m_14165_((double)((double)resource.getAmount() * 0.4));
            if (amountToAdd > 0) {
                this.jar.add(data, amountToAdd);
                return resource.getAmount();
            }
            return 0;
        }
        if (!data.areSameEffects(this.jar.getData())) {
            return 0;
        }
        int filled = this.capacity - this.getFluidAmount();
        int amountToAdd = Mth.m_14165_((double)((double)resource.getAmount() * 0.4));
        if (amountToAdd > 0) {
            this.jar.add(data, amountToAdd);
            if (resource.getAmount() < filled) {
                filled = resource.getAmount();
            }
        }
        return filled;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int drained = maxDrain;
        if (this.getFluidAmount() < drained) {
            drained = this.getFluidAmount();
        }
        FluidStack stack = PotionFluidHandler.getFluidFromPotion((Potion)this.jar.getData().getPotion(), (PotionFluid.BottleType)PotionFluid.BottleType.REGULAR, (int)drained);
        if (action.execute() && drained > 0) {
            this.jar.remove(Mth.m_14165_((double)((double)drained * 0.4)));
        }
        return stack;
    }
}

