/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.emi;

import com.christofmeg.justenoughbreeding.JustEnoughBreeding;
import com.christofmeg.justenoughbreeding.client.ClientUtils;
import com.christofmeg.justenoughbreeding.emi.AllayDuplicationCategoryEMI;
import com.christofmeg.justenoughbreeding.emi.BreedingCategoryEMI;
import com.christofmeg.justenoughbreeding.emi.TamingCategoryEMI;
import com.christofmeg.justenoughbreeding.emi.TemperCategoryEMI;
import com.christofmeg.justenoughbreeding.emi.TransformationCategoryEMI;
import com.christofmeg.justenoughbreeding.emi.TrustingCategoryEMI;
import com.christofmeg.justenoughbreeding.recipe.AllayDuplicationRecipe;
import com.christofmeg.justenoughbreeding.recipe.BaseRecipe;
import com.christofmeg.justenoughbreeding.recipe.BreedingRecipe;
import com.christofmeg.justenoughbreeding.recipe.TamingRecipe;
import com.christofmeg.justenoughbreeding.recipe.TemperRecipe;
import com.christofmeg.justenoughbreeding.recipe.TransformationRecipe;
import com.christofmeg.justenoughbreeding.recipe.TrustingRecipe;
import com.christofmeg.justenoughbreeding.utils.CommonClientUtils;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;

public class EMIUtils {
    public static void registerRecipes(EmiRegistry registration) {
        ArrayList<AllayDuplicationRecipe> allayDuplicationRecipes = new ArrayList<AllayDuplicationRecipe>(registration.getRecipeManager().m_44013_((RecipeType)JustEnoughBreeding.ALLAY_DUPLICATION_PROVIDER_TYPE.get()));
        allayDuplicationRecipes.sort(Comparator.comparing(r -> r.jsonAnimalID == null ? "" : r.jsonAnimalID));
        for (AllayDuplicationRecipe allayDuplicationRecipe : allayDuplicationRecipes) {
            if (!JustEnoughBreeding.isModLoaded(allayDuplicationRecipe.jsonModID).booleanValue() || allayDuplicationRecipe.entityType == null || allayDuplicationRecipe.inputStack.m_43947_()) continue;
            registration.addRecipe(AllayDuplicationCategoryEMI.builder().id(new ResourceLocation("justenoughbreeding", "/allay_duplication/" + allayDuplicationRecipe.jsonModID + "/" + allayDuplicationRecipe.jsonAnimalID)).recipe(allayDuplicationRecipe).build());
        }
        ArrayList<BreedingRecipe> breedingRecipes = new ArrayList<BreedingRecipe>(registration.getRecipeManager().m_44013_((RecipeType)JustEnoughBreeding.BREEDING_PROVIDER_TYPE.get()));
        breedingRecipes.sort(Comparator.comparing(r -> r.jsonAnimalID == null ? "" : r.jsonAnimalID));
        for (BreedingRecipe breedingRecipe : breedingRecipes) {
            if (!JustEnoughBreeding.isModLoaded(breedingRecipe.jsonModID).booleanValue() || breedingRecipe.entityType == null || breedingRecipe.inputStack.m_43947_()) continue;
            registration.addRecipe(BreedingCategoryEMI.builder().id(new ResourceLocation("justenoughbreeding", "/breeding/" + breedingRecipe.jsonModID + "/" + breedingRecipe.jsonAnimalID)).recipe(breedingRecipe).build());
        }
        ArrayList<TamingRecipe> arrayList = new ArrayList<TamingRecipe>(registration.getRecipeManager().m_44013_((RecipeType)JustEnoughBreeding.TAMING_PROVIDER_TYPE.get()));
        arrayList.sort(Comparator.comparing(r -> r.jsonAnimalID == null ? "" : r.jsonAnimalID));
        for (TamingRecipe tamingRecipe : arrayList) {
            if (!JustEnoughBreeding.isModLoaded(tamingRecipe.jsonModID).booleanValue() || tamingRecipe.entityType == null || tamingRecipe.inputStack.m_43947_()) continue;
            registration.addRecipe(TamingCategoryEMI.builder().id(new ResourceLocation("justenoughbreeding", "/taming/" + tamingRecipe.jsonModID + "/" + tamingRecipe.jsonAnimalID)).recipe(tamingRecipe).build());
        }
        ArrayList<TemperRecipe> arrayList2 = new ArrayList<TemperRecipe>(registration.getRecipeManager().m_44013_((RecipeType)JustEnoughBreeding.TEMPER_PROVIDER_TYPE.get()));
        arrayList2.sort(Comparator.comparing(r -> r.jsonAnimalID == null ? "" : r.jsonAnimalID));
        for (TemperRecipe temperRecipe : arrayList2) {
            if (!JustEnoughBreeding.isModLoaded(temperRecipe.jsonModID).booleanValue() || temperRecipe.entityType == null || temperRecipe.inputStack.m_43947_()) continue;
            registration.addRecipe(TemperCategoryEMI.builder().id(new ResourceLocation("justenoughbreeding", "/temper/" + temperRecipe.jsonModID + "/" + temperRecipe.jsonAnimalID)).recipe(temperRecipe).build());
        }
        ArrayList<TransformationRecipe> arrayList3 = new ArrayList<TransformationRecipe>(registration.getRecipeManager().m_44013_((RecipeType)JustEnoughBreeding.TRANSFORMATION_PROVIDER_TYPE.get()));
        arrayList3.sort(Comparator.comparing(r -> r.outputEntityType == null ? r.fileName : r.outputEntityType.m_147048_()));
        for (TransformationRecipe recipe : arrayList3) {
            if (!JustEnoughBreeding.isModLoaded(recipe.jsonModID).booleanValue() || recipe.inputEntityType == null || recipe.outputEntityType == null || recipe.inputStack.m_43947_()) continue;
            registration.addRecipe(TransformationCategoryEMI.builder().id(new ResourceLocation("justenoughbreeding", "/transformation/" + recipe.jsonModID + "/" + recipe.modFolder + "/" + recipe.fileName)).recipe(recipe).build());
        }
        ArrayList<TrustingRecipe> arrayList4 = new ArrayList<TrustingRecipe>(registration.getRecipeManager().m_44013_((RecipeType)JustEnoughBreeding.TRUSTING_PROVIDER_TYPE.get()));
        arrayList4.sort(Comparator.comparing(r -> r.jsonAnimalID == null ? "" : r.jsonAnimalID));
        for (TrustingRecipe recipe : arrayList4) {
            if (!JustEnoughBreeding.isModLoaded(recipe.jsonModID).booleanValue() || recipe.entityType == null || recipe.inputStack.m_43947_()) continue;
            registration.addRecipe(TrustingCategoryEMI.builder().id(new ResourceLocation("justenoughbreeding", "/trusting/" + recipe.jsonModID + "/" + recipe.jsonAnimalID)).recipe(recipe).build());
        }
    }

    public static void drawMobSlot(int mobSlotX, int mobSlotY, WidgetHolder widgets) {
        EmiTexture TOP = new EmiTexture(EmiRenderHelper.WIDGETS, 19, 0, 24, 1);
        EmiTexture CORNER = new EmiTexture(EmiRenderHelper.WIDGETS, 43, 0, 1, 1);
        EmiTexture LEFT = new EmiTexture(EmiRenderHelper.WIDGETS, 18, 0, 1, 25);
        EmiTexture RIGHT = new EmiTexture(EmiRenderHelper.WIDGETS, 43, 1, 1, 25);
        EmiTexture BOTTOM = new EmiTexture(EmiRenderHelper.WIDGETS, 19, 25, 25, 1);
        widgets.addTexture(TOP, mobSlotX + 2, mobSlotY + 1);
        widgets.addTexture(TOP, mobSlotX + 26, mobSlotY + 1);
        widgets.addTexture(new EmiTexture(EmiRenderHelper.WIDGETS, 19, 0, 11, 1), mobSlotX + 50, mobSlotY + 1);
        widgets.addTexture(CORNER, mobSlotX + 61, mobSlotY + 1);
        widgets.addTexture(LEFT, mobSlotX + 1, mobSlotY + 2);
        widgets.addTexture(LEFT, mobSlotX + 1, mobSlotY + 27);
        widgets.addTexture(LEFT, mobSlotX + 1, mobSlotY + 52);
        widgets.addTexture(LEFT, mobSlotX + 1, mobSlotY + 56);
        widgets.addTexture(RIGHT, mobSlotX + 61, mobSlotY + 2);
        widgets.addTexture(RIGHT, mobSlotX + 61, mobSlotY + 27);
        widgets.addTexture(RIGHT, mobSlotX + 61, mobSlotY + 52);
        widgets.addTexture(RIGHT, mobSlotX + 61, mobSlotY + 56);
        int color = CommonClientUtils.getPixelColor(new ResourceLocation("emi", "textures/gui/widgets.png"), 30, 12);
        if (color == 0) {
            color = -7631989;
        }
        int startX = mobSlotX + 1;
        int startY = mobSlotY - 4;
        int width = 59;
        int height = 79;
        int finalColor = color;
        widgets.addDrawable(1, startY, width, height, (guiGraphics, mouseX, mouseY, delta) -> guiGraphics.m_280509_(startX, startY, startX + width, startY + height, finalColor));
        widgets.addTexture(CORNER, mobSlotX + 1, mobSlotY + 81);
        widgets.addTexture(BOTTOM, mobSlotX + 2, mobSlotY + 81);
        widgets.addTexture(BOTTOM, mobSlotX + 27, mobSlotY + 81);
        widgets.addTexture(BOTTOM, mobSlotX + 37, mobSlotY + 81);
    }

    public static void drawMobNameAndEntity(EntityType<?> entityType, WidgetHolder widgets, BaseRecipe recipe) {
        EMIUtils.drawMobNameAndEntity(entityType, widgets, recipe, 148, 0);
    }

    public static void drawMobNameAndEntity(EntityType<?> entityType, WidgetHolder widgets, BaseRecipe recipe, int availableWidth, int extraX) {
        EMIUtils.drawMobNameAndEntity(entityType, widgets, recipe, availableWidth, extraX, true);
    }

    public static void drawMobNameAndEntity(final EntityType<?> entityType, WidgetHolder widgets, final BaseRecipe recipe, int availableWidth, final int extraX, final boolean input) {
        if (entityType != null) {
            Font font = Minecraft.m_91087_().f_91062_;
            MutableComponent entityName = Component.m_237115_((String)entityType.m_20675_());
            Object entityNameString = entityName.getString();
            if (recipe instanceof BreedingRecipe) {
                BreedingRecipe breedingRecipe = (BreedingRecipe)recipe;
                if (breedingRecipe.needsToBeTamed != null && breedingRecipe.needsToBeTamed.booleanValue()) {
                    tamed = Component.m_237115_((String)"translation.justenoughbreeding.tamed");
                    entityNameString = (String)entityNameString + " (" + tamed.getString() + ")";
                } else if (breedingRecipe.animalTrusting != null && breedingRecipe.animalTrusting.booleanValue()) {
                    MutableComponent trusting = Component.m_237115_((String)"translation.justenoughbreeding.trusting");
                    entityNameString = (String)entityNameString + " (" + trusting.getString() + ")";
                } else if ("tfc".equals(breedingRecipe.jsonModID)) {
                    MutableComponent familiarity = Component.m_237115_((String)"tfc.jade.familiarity");
                    String tfc = familiarity.getString().replaceAll(":[^:]*$", "");
                    entityNameString = (String)entityNameString + " (" + tfc + " > 30)";
                }
            } else if (recipe instanceof TransformationRecipe) {
                TransformationRecipe transformationRecipe = (TransformationRecipe)recipe;
                if (input && transformationRecipe.needsToBeTamed != null && transformationRecipe.needsToBeTamed.booleanValue()) {
                    tamed = Component.m_237115_((String)"translation.justenoughbreeding.tamed");
                    entityNameString = (String)entityNameString + " (" + tamed.getString() + ")";
                }
            }
            int stringWidth = font.m_92895_((String)entityNameString);
            if (stringWidth > availableWidth) {
                float pixelWidthPerCharacter = (float)stringWidth / (float)Math.max(1, ((String)entityNameString).length());
                int maxCharacters = Math.max(0, (int)((float)availableWidth / pixelWidthPerCharacter));
                entityNameString = ((String)entityNameString).substring(0, Math.min(((String)entityNameString).length(), maxCharacters));
            }
            if (!((String)entityNameString).isEmpty()) {
                Component abbreviatedEntityName = Component.m_130674_((String)entityNameString);
                widgets.addText(EmiPort.ordered((Component)abbreviatedEntityName), extraX + 1, 1, -1, true);
            }
            widgets.add(new Widget(){

                public Bounds getBounds() {
                    return new Bounds(100, 0, 60, 80);
                }

                public void m_88315_(@NotNull GuiGraphics stack, int mouseX, int mouseY, float delta) {
                    LivingEntity currentLivingEntity;
                    TransformationRecipe transformationRecipe;
                    if (recipe instanceof TransformationRecipe) {
                        transformationRecipe = (TransformationRecipe)recipe;
                        currentLivingEntity = input ? ClientUtils.doRendering(transformationRecipe.inputEntityType, transformationRecipe.inputEntityNbt, true) : ClientUtils.doRendering(transformationRecipe.outputEntityType, transformationRecipe.outputEntityNbt, false);
                    } else {
                        currentLivingEntity = ClientUtils.doRendering(entityType);
                    }
                    if (currentLivingEntity != null) {
                        if (input) {
                            if (recipe instanceof TransformationRecipe) {
                                transformationRecipe = (TransformationRecipe)recipe;
                                if (transformationRecipe.inputEntityNbt != null) {
                                    currentLivingEntity.m_20258_(transformationRecipe.inputEntityNbt);
                                }
                            }
                            if (recipe instanceof AllayDuplicationRecipe) {
                                AllayDuplicationRecipe allayDuplicationRecipe = (AllayDuplicationRecipe)recipe;
                                if (allayDuplicationRecipe.inputEntityNbt != null) {
                                    currentLivingEntity.m_20258_(allayDuplicationRecipe.inputEntityNbt);
                                }
                            }
                            if (recipe instanceof BreedingRecipe) {
                                BreedingRecipe breedingRecipe = (BreedingRecipe)recipe;
                                if (breedingRecipe.inputEntityNbt != null) {
                                    currentLivingEntity.m_20258_(breedingRecipe.inputEntityNbt);
                                }
                            }
                            if (recipe instanceof TamingRecipe) {
                                TamingRecipe tamingRecipe = (TamingRecipe)recipe;
                                if (tamingRecipe.inputEntityNbt != null) {
                                    currentLivingEntity.m_20258_(tamingRecipe.inputEntityNbt);
                                }
                            }
                            if (recipe instanceof TemperRecipe) {
                                TemperRecipe temperRecipe = (TemperRecipe)recipe;
                                if (temperRecipe.inputEntityNbt != null) {
                                    currentLivingEntity.m_20258_(temperRecipe.inputEntityNbt);
                                }
                            }
                            if (recipe instanceof TrustingRecipe) {
                                TrustingRecipe trustingRecipe = (TrustingRecipe)recipe;
                                if (trustingRecipe.inputEntityNbt != null) {
                                    currentLivingEntity.m_20258_(trustingRecipe.inputEntityNbt);
                                }
                            }
                        } else if (recipe instanceof TransformationRecipe) {
                            transformationRecipe = (TransformationRecipe)recipe;
                            if (transformationRecipe.outputEntityNbt != null) {
                                currentLivingEntity.m_20258_(transformationRecipe.outputEntityNbt);
                            }
                        }
                        CommonClientUtils.renderEntity(stack.m_280168_(), mouseX, currentLivingEntity, 31 + extraX, 89);
                    }
                }
            });
        }
    }
}

