/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.init.v3.tags;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;

public final class BoundTagFactory {
    private static final Map<String, BoundTagFactory> VALUES = Maps.newConcurrentMap();
    public static final BoundTagFactory MINECRAFT = BoundTagFactory.make("minecraft");
    public static final BoundTagFactory COMMON = BoundTagFactory.make("c");
    public static final BoundTagFactory FABRIC = BoundTagFactory.make("fabric");
    public static final BoundTagFactory FORGE = BoundTagFactory.make("forge");
    public static final BoundTagFactory CURIOS = BoundTagFactory.make("curios");
    public static final BoundTagFactory TRINKETS = BoundTagFactory.make("trinkets");
    private final String namespace;

    private BoundTagFactory(String namespace) {
        this.namespace = namespace;
    }

    public static BoundTagFactory make(String namespace) {
        return VALUES.computeIfAbsent(namespace, BoundTagFactory::new);
    }

    public <T> TagKey<T> registerTagKey(ResourceKey<? extends Registry<T>> registryKey, String path) {
        return TagKey.m_203882_(registryKey, (ResourceLocation)new ResourceLocation(this.namespace, path));
    }

    public TagKey<Block> registerBlockTag(String path) {
        return this.registerTagKey(Registries.f_256747_, path);
    }

    public TagKey<Item> registerItemTag(String path) {
        return this.registerTagKey(Registries.f_256913_, path);
    }

    public TagKey<Fluid> registerFluidTag(String path) {
        return this.registerTagKey(Registries.f_256808_, path);
    }

    public TagKey<EntityType<?>> registerEntityTypeTag(String path) {
        return this.registerTagKey(Registries.f_256939_, path);
    }

    public TagKey<Enchantment> registerEnchantmentTag(String path) {
        return this.registerTagKey(Registries.f_256762_, path);
    }

    public TagKey<Biome> registerBiomeTag(String path) {
        return this.registerTagKey(Registries.f_256952_, path);
    }

    public TagKey<GameEvent> registerGameEventTag(String path) {
        return this.registerTagKey(Registries.f_256827_, path);
    }

    public TagKey<DamageType> registerDamageTypeTag(String path) {
        return this.registerTagKey(Registries.f_268580_, path);
    }
}

