/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.icon;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.registry.registries.RegistrarManager;
import dev.ftb.mods.ftblibrary.icon.CustomIconItem;
import dev.ftb.mods.ftblibrary.icon.IResourceIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.LazyIcon;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ItemIcon
extends Icon
implements IResourceIcon {
    private final ItemStack stack;

    public static Icon getItemIcon(ItemStack stack) {
        if (stack.m_41619_()) {
            return ItemIcon.empty();
        }
        if (stack.m_41720_() instanceof CustomIconItem) {
            return ((CustomIconItem)stack.m_41720_()).getCustomIcon(stack);
        }
        return new ItemIcon(stack);
    }

    public static Icon getItemIcon(Item item) {
        return item == Items.f_41852_ ? ItemIcon.empty() : ItemIcon.getItemIcon(item.m_7968_());
    }

    public static Icon getItemIcon(final String lazyStackString) {
        if (lazyStackString.isEmpty()) {
            return ItemIcon.empty();
        }
        return new LazyIcon(() -> {
            String[] s = lazyStackString.split(" ", 4);
            ItemStack stack = ((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(s[0]))).m_7968_();
            if (s.length >= 2 && !s[1].equals("1")) {
                stack.m_41764_(Integer.parseInt(s[1]));
            }
            if (s.length >= 3 && !s[2].equals("0")) {
                stack.m_41721_(Integer.parseInt(s[2]));
            }
            if (s.length >= 4 && !s[3].equals("null")) {
                try {
                    stack.m_41751_(TagParser.m_129359_((String)s[3]));
                }
                catch (CommandSyntaxException ex) {
                    ex.printStackTrace();
                }
            }
            if (stack.m_41619_()) {
                stack = new ItemStack((ItemLike)Items.f_42127_);
                stack.m_41714_((Component)Component.m_237113_((String)lazyStackString));
            }
            return ItemIcon.getItemIcon(stack);
        }){

            @Override
            public String toString() {
                return "item:" + lazyStackString;
            }
        };
    }

    private ItemIcon(ItemStack is) {
        this.stack = is;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiGraphics graphics, int x, int y, int w, int h) {
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)x + (double)w / 2.0, (double)y + (double)h / 2.0, 100.0);
        if (w != 16 || h != 16) {
            int s = Math.min(w, h);
            poseStack.m_85841_((float)s / 16.0f, (float)s / 16.0f, (float)s / 16.0f);
        }
        GuiHelper.drawItem(graphics, this.getStack(), 0, true, null);
        poseStack.m_85849_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawStatic(GuiGraphics graphics, int x, int y, int w, int h) {
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)x + (double)w / 2.0, (double)y + (double)h / 2.0, 100.0);
        if (w != 16 || h != 16) {
            int s = Math.min(w, h);
            poseStack.m_85841_((float)s / 16.0f, (float)s / 16.0f, (float)s / 16.0f);
        }
        GuiHelper.drawItem(graphics, this.getStack(), 0, false, null);
        poseStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawItem3D(GuiGraphics graphics, ItemStack stack) {
        Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, 240, OverlayTexture.f_118083_, graphics.m_280168_(), (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), (Level)Minecraft.m_91087_().f_91073_, 0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw3D(GuiGraphics graphics) {
        ItemIcon.drawItem3D(graphics, this.getStack());
    }

    public String toString() {
        ItemStack is = this.getStack();
        StringBuilder builder = new StringBuilder("item:");
        builder.append(RegistrarManager.getId((Object)is.m_41720_(), (ResourceKey)Registries.f_256913_));
        int count = is.m_41613_();
        int damage = is.m_41773_();
        CompoundTag nbt = is.m_41783_();
        if (count > 1 || damage > 0 || nbt != null) {
            builder.append(' ');
            builder.append(count);
        }
        if (damage > 0 || nbt != null) {
            builder.append(' ');
            builder.append(damage);
        }
        if (nbt != null) {
            builder.append(' ');
            builder.append(nbt);
        }
        return builder.toString();
    }

    @Override
    public int hashCode() {
        ItemStack stack = this.getStack();
        int h = stack.m_41720_().hashCode();
        h = h * 31 + stack.m_41613_();
        h = h * 31 + Objects.hashCode(stack.m_41783_());
        return h;
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof ItemIcon && ItemStack.m_41728_((ItemStack)this.getStack(), (ItemStack)((ItemIcon)o).getStack());
    }

    @Override
    @Nullable
    public Object getIngredient() {
        return this.getStack();
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return BuiltInRegistries.f_257033_.m_7981_((Object)this.stack.m_41720_());
    }
}

