/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.util.client;

import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import net.minecraft.network.chat.ComponentContents;

public class ImageComponent
implements ComponentContents {
    public Icon image = Icon.empty();
    public int width = 100;
    public int height = 100;
    public ImageAlign align = ImageAlign.CENTER;
    public boolean fit = false;

    public String toString() {
        StringBuilder sb = new StringBuilder("{image:");
        sb.append(this.image);
        sb.append(" width:").append(this.width);
        sb.append(" height:").append(this.height);
        sb.append(" align:").append(this.align.name);
        if (this.fit) {
            sb.append(" fit:true");
        }
        sb.append('}');
        return sb.toString();
    }

    public static enum ImageAlign {
        LEFT("left"),
        CENTER("center"),
        RIGHT("right");

        public static final NameMap<ImageAlign> NAME_MAP;
        private final String name;

        private ImageAlign(String name) {
            this.name = name;
        }

        public static ImageAlign fromString(String str) {
            return switch (str.toLowerCase()) {
                case "left", "0" -> LEFT;
                case "right", "2" -> RIGHT;
                default -> CENTER;
            };
        }

        static {
            NAME_MAP = NameMap.of(CENTER, ImageAlign.values()).id(v -> v.name).create();
        }
    }
}

