/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.part;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.event.GetStatModifierEvent;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.MaterialList;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.api.part.IPartSerializer;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.client.util.ColorUtils;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.gear.part.AbstractGearPart;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.gear.part.PartSerializers;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.SynergyUtils;
import net.silentchaos512.gear.util.TierHelper;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.utils.MathUtils;

public class CompoundPart
extends AbstractGearPart {
    private GearType gearType = GearType.ALL;
    private PartType partType;

    public CompoundPart(ResourceLocation name) {
        super(name);
    }

    @Override
    public GearType getGearType() {
        return this.gearType;
    }

    @Nullable
    public static MaterialInstance getPrimaryMaterial(IPartData part) {
        return CompoundPartItem.getPrimaryMaterial(part.getItem());
    }

    @Override
    public int getTier(PartData part) {
        MaterialInstance material = CompoundPart.getPrimaryMaterial(part);
        return material != null ? material.getTier(this.partType) : super.getTier(part);
    }

    @Override
    public Tier getHarvestTier(IPartData part) {
        return TierHelper.getHighestTier(this.getMaterials(part));
    }

    @Override
    public PartType getType() {
        return this.partType;
    }

    @Override
    public IPartSerializer<?> getSerializer() {
        return PartSerializers.COMPOUND_PART;
    }

    @Override
    public int getColor(PartData part, ItemStack gear, int layer, int animationFrame) {
        MaterialList materials = this.getMaterials(part);
        if (gear.m_41720_() instanceof ICoreItem) {
            return ColorUtils.getBlendedColor((ICoreItem)gear.m_41720_(), part, materials, layer);
        }
        return ColorUtils.getBlendedColor((CompoundPartItem)part.getItem().m_41720_(), (Collection<? extends IMaterialInstance>)materials, layer);
    }

    @Override
    public Component getDisplayName(@Nullable PartData part, ItemStack gear) {
        if (part != null) {
            return part.getItem().m_41786_();
        }
        return super.getDisplayName(null, gear);
    }

    @Override
    public Component getDisplayNamePrefix(@Nullable PartData part, ItemStack gear) {
        MaterialInstance material;
        if (part != null && (material = CompoundPart.getPrimaryMaterial(part)) != null) {
            return material.get().getDisplayNamePrefix(gear, this.partType);
        }
        return super.getDisplayNamePrefix(part, gear);
    }

    @Override
    public Component getMaterialName(@Nullable PartData part, ItemStack gear) {
        MaterialInstance material;
        if (part != null && (material = CompoundPart.getPrimaryMaterial(part)) != null) {
            return material.getDisplayName(this.partType, gear);
        }
        return super.getMaterialName(null, gear);
    }

    @Override
    public String getModelKey(PartData part) {
        String str = "{" + this.getMaterials(part).stream().map(IMaterialInstance::getModelKey).collect(Collectors.joining(",")) + "}";
        return super.getModelKey(part) + str;
    }

    @Override
    public Collection<StatInstance> getStatModifiers(IPartData part, PartType partType, StatGearKey key, ItemStack gear) {
        float synergy;
        MaterialList materials = this.getMaterials(part);
        List<StatInstance> statMods = materials.stream().flatMap(m -> m.getStatModifiers(partType, key).stream()).collect(Collectors.toList());
        statMods.addAll(this.stats.get(key));
        if (statMods.isEmpty()) {
            return statMods;
        }
        GetStatModifierEvent event = new GetStatModifierEvent((PartData)part, (ItemStat)key.getStat(), statMods);
        MinecraftForge.EVENT_BUS.post((Event)event);
        ArrayList<StatInstance> ret = new ArrayList<StatInstance>(event.getModifiers());
        for (StatInstance.Operation op : StatInstance.Operation.values()) {
            Collection modsForOp = ret.stream().filter(s -> s.getOp() == op).collect(Collectors.toList());
            if (modsForOp.size() <= 1) continue;
            StatInstance mod = CompoundPart.compressModifiers(modsForOp, op, key);
            ret.removeIf(inst -> inst.getOp() == op);
            ret.add(mod);
        }
        if (key.getStat().doesSynergyApply() && !MathUtils.floatsEqual((float)(synergy = SynergyUtils.getSynergy(this.partType, materials, this.getTraits(part, PartGearKey.of(this.gearType, partType), gear))), (float)1.0f)) {
            float multi = synergy - 1.0f;
            for (int i = 0; i < ret.size(); ++i) {
                StatInstance oldMod = (StatInstance)ret.get(i);
                float value = oldMod.getValue();
                StatInstance newMod = oldMod.copySetValue(value + Math.abs(value) * multi);
                ret.remove(i);
                ret.add(i, newMod);
            }
        }
        return ret;
    }

    private static StatInstance compressModifiers(Collection<StatInstance> mods, StatInstance.Operation operation, StatGearKey key) {
        if (operation == StatInstance.Operation.MAX) {
            return mods.stream().max((o1, o2) -> Float.compare(o1.getValue(), o2.getValue())).orElse(StatInstance.of(0.0f, operation, key)).copy();
        }
        return StatInstance.getWeightedAverageMod(mods, operation);
    }

    @Override
    public Collection<TraitInstance> getTraits(IPartData part, PartGearKey partKey, ItemStack gear) {
        ArrayList<TraitInstance> ret = new ArrayList<TraitInstance>(super.getTraits(part, partKey, gear));
        MaterialList materials = this.getMaterials(part);
        for (TraitInstance inst : TraitHelper.getTraits(materials, partKey, gear)) {
            if (!inst.conditionsMatch(partKey, gear, materials)) continue;
            ret.add(inst);
        }
        return ret;
    }

    @Override
    public MaterialList getMaterials(IPartData part) {
        return CompoundPartItem.getMaterials(part.getItem());
    }

    @Override
    public PartData randomizeData(GearType gearType, int tier) {
        for (ItemStack stack : this.getIngredient().m_43908_()) {
            if (!(stack.m_41720_() instanceof CompoundPartItem)) continue;
            int materialCount = CompoundPart.getRandomMaterialCount(this.partType);
            List<MaterialInstance> materials = this.getRandomMaterials(gearType, materialCount, tier);
            ItemStack craftingItem = ((CompoundPartItem)stack.m_41720_()).create(materials);
            return PartData.of(this, craftingItem);
        }
        return super.randomizeData(gearType, tier);
    }

    @Override
    public boolean canAddToGear(ItemStack gear, PartData part) {
        GearType type = GearHelper.getType(gear);
        return type.matches(this.gearType);
    }

    private static int getRandomMaterialCount(PartType partType) {
        if (partType == PartType.MAIN) {
            int ret = 1;
            for (int i = 0; i < 3 && SilentGear.RANDOM.nextInt(100) < 70 - 30 * i; ++i) {
                ++ret;
            }
            return ret;
        }
        return SilentGear.RANDOM.nextInt(2) + 1;
    }

    private List<MaterialInstance> getRandomMaterials(GearType gearType, int count, int tier) {
        List matsOfTier = MaterialManager.getValues(tier == 0).stream().map(MaterialInstance::of).filter(m -> tier < 0 || tier == m.getTier(this.partType)).filter(m -> m.allowedInPart(this.partType) && m.isCraftingAllowed(this.partType, gearType)).map(MaterialInstance::get).collect(Collectors.toList());
        if (!matsOfTier.isEmpty()) {
            ArrayList<MaterialInstance> ret = new ArrayList<MaterialInstance>();
            for (int i = 0; i < count; ++i) {
                IMaterial material = (IMaterial)matsOfTier.get(SilentGear.RANDOM.nextInt(matsOfTier.size()));
                ret.add(CompoundPart.getRandomChildMaterial(material));
            }
            return ret;
        }
        if (tier == -1) {
            return Collections.emptyList();
        }
        return this.getRandomMaterials(gearType, count, -1);
    }

    private static MaterialInstance getRandomChildMaterial(IMaterial material) {
        List<IMaterial> children = MaterialManager.getChildren(material);
        if (children.isEmpty()) {
            return MaterialInstance.of(material);
        }
        return MaterialInstance.of(children.get(SilentGear.RANDOM.nextInt(children.size())));
    }

    @Override
    public String toString() {
        return "CompoundPart{id=" + this.getId() + ", partType=" + this.partType + "}";
    }

    public static class Serializer
    extends AbstractGearPart.Serializer<CompoundPart> {
        Serializer(ResourceLocation serializerId, Function<ResourceLocation, CompoundPart> function) {
            super(serializerId, function);
        }

        @Override
        public CompoundPart read(ResourceLocation id, JsonObject json) {
            CompoundPart part = (CompoundPart)super.read(id, json, false);
            String gearTypeStr = GsonHelper.m_13906_((JsonObject)json, (String)"gear_type");
            part.gearType = GearType.get(gearTypeStr);
            if (!part.gearType.isGear()) {
                throw new JsonParseException("Unknown gear type: " + gearTypeStr);
            }
            part.partType = PartType.get(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"part_type")));
            return part;
        }

        @Override
        public CompoundPart read(ResourceLocation id, FriendlyByteBuf buffer) {
            CompoundPart part = (CompoundPart)super.read(id, buffer);
            part.gearType = GearType.get(buffer.m_130277_());
            part.partType = PartType.get(buffer.m_130281_());
            return part;
        }

        @Override
        public void write(FriendlyByteBuf buffer, CompoundPart part) {
            super.write(buffer, part);
            buffer.m_130070_(part.gearType.getName());
            buffer.m_130085_(part.partType.getName());
        }
    }
}

