/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.MaterialList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.util.ColorUtils;
import net.silentchaos512.gear.client.util.TextListBuilder;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.setup.SgItems;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.SynergyUtils;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.NameUtils;
import net.silentchaos512.utils.Color;

public class CompoundPartItem
extends Item {
    private static final String NBT_CRAFTED_COUNT = "CraftedCount";
    private static final String NBT_MATERIALS = "Materials";
    private final PartType partType;

    public CompoundPartItem(PartType partType, Item.Properties properties) {
        super(properties);
        this.partType = partType;
    }

    public PartType getPartType() {
        return this.partType;
    }

    public GearType getGearType() {
        return GearType.PART;
    }

    public int getCraftedCount(ItemStack stack) {
        if (stack.m_41784_().m_128441_(NBT_CRAFTED_COUNT)) {
            return stack.m_41784_().m_128451_(NBT_CRAFTED_COUNT);
        }
        if (this == SgItems.BINDING.get()) {
            return CompoundPartItem.getMaterials(stack).size();
        }
        if (this == SgItems.CORD.get()) {
            return 1;
        }
        if (this == SgItems.COATING.get()) {
            return CompoundPartItem.getMaterials(stack).size();
        }
        if (this == SgItems.FLETCHING.get()) {
            return CompoundPartItem.getMaterials(stack).size();
        }
        if (this == SgItems.GRIP.get()) {
            return CompoundPartItem.getMaterials(stack).size();
        }
        if (this == SgItems.ROD.get()) {
            return 4;
        }
        if (this == SgItems.TIP.get()) {
            return CompoundPartItem.getMaterials(stack).size();
        }
        SilentGear.LOGGER.error("Unknown part with no crafted count: {}", (Object)stack);
        return 1;
    }

    public ItemStack create(IMaterialInstance material) {
        return this.create(material, -1);
    }

    public ItemStack create(Collection<? extends IMaterialInstance> materials) {
        return this.create(MaterialList.of(materials), -1);
    }

    public ItemStack create(IMaterialInstance material, int craftedCount) {
        return this.create(MaterialList.of(material), craftedCount);
    }

    public ItemStack create(MaterialList materials) {
        return this.create(materials, -1);
    }

    public ItemStack create(MaterialList materials, int craftedCount) {
        ListTag materialListNbt = materials.serializeNbt();
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(NBT_MATERIALS, (Tag)materialListNbt);
        if (craftedCount > 0) {
            tag.m_128405_(NBT_CRAFTED_COUNT, craftedCount);
        }
        ItemStack result = new ItemStack((ItemLike)this, craftedCount > 0 ? craftedCount : 1);
        result.m_41751_(tag);
        return result;
    }

    public static MaterialList getMaterials(ItemStack stack) {
        ListTag materialListNbt = stack.m_41784_().m_128437_(NBT_MATERIALS, 10);
        return MaterialList.deserializeNbt(materialListNbt);
    }

    @Nullable
    public static MaterialInstance getPrimaryMaterial(ItemStack stack) {
        Tag nbt;
        if (stack.m_41619_()) {
            return null;
        }
        ListTag listNbt = stack.m_41784_().m_128437_(NBT_MATERIALS, 10);
        if (!listNbt.isEmpty() && (nbt = listNbt.get(0)) instanceof CompoundTag) {
            return MaterialInstance.read((CompoundTag)nbt);
        }
        return null;
    }

    public static String getModelKey(ItemStack stack) {
        StringBuilder s = new StringBuilder(SilentGear.shortenId(NameUtils.fromItem((ItemStack)stack)) + "#");
        if (!stack.m_41782_()) {
            return s.append(Const.Materials.EXAMPLE.getId()).toString();
        }
        for (IMaterialInstance material : CompoundPartItem.getMaterials(stack)) {
            s.append(SilentGear.shortenId(material.getId()));
        }
        return s.toString();
    }

    public int getColor(ItemStack stack, int layer) {
        if (layer == 0) {
            int colorLayer = this == SgItems.TIP.get() ? 1 : 0;
            return ColorUtils.getBlendedColor(this, (Collection<? extends IMaterialInstance>)CompoundPartItem.getMaterials(stack), colorLayer);
        }
        return 0xFFFFFF;
    }

    public int getColorWeight(int index, int totalCount) {
        return totalCount - index;
    }

    public Component m_7626_(ItemStack stack) {
        PartData part = PartData.from(stack);
        MaterialInstance material = CompoundPartItem.getPrimaryMaterial(stack);
        if (part != null && material != null) {
            MutableComponent nameText = Component.m_237110_((String)(this.m_5524_() + ".nameProper"), (Object[])new Object[]{material.getDisplayName(this.partType, ItemStack.f_41583_)});
            int nameColor = Color.blend((int)part.getColor(ItemStack.f_41583_), (int)0xFFFFFF, (float)0.25f) & 0xFFFFFF;
            return TextUtil.withColor(nameText, nameColor);
        }
        return super.m_7626_(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        PartData part = PartData.from(stack);
        if (part != null && ((Boolean)Config.Client.showPartTooltips.get()).booleanValue()) {
            if (((Boolean)Config.Common.allowLegacyMaterialMixing.get()).booleanValue()) {
                float synergy = SynergyUtils.getSynergy(this.partType, CompoundPartItem.getMaterials(stack), part.getTraits());
                tooltip.add(SynergyUtils.getDisplayText(synergy));
            }
            TextListBuilder matsBuilder = new TextListBuilder();
            CompoundPartItem.getMaterials(stack).forEach(material -> {
                int nameColor = material.getNameColor(part.getType(), this.getGearType());
                matsBuilder.add((Component)TextUtil.withColor(material.getDisplayNameWithModifiers(part.getType(), ItemStack.f_41583_), nameColor));
            });
            tooltip.addAll(matsBuilder.build());
        }
    }
}

