/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.goblintraders.client.renderer.entity.GoblinModelLayers;
import com.mrcrayfish.goblintraders.client.renderer.entity.model.GoblinTraderModel;
import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class GoblinTraderRenderer
extends MobRenderer<AbstractGoblinEntity, GoblinTraderModel> {
    public GoblinTraderRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new GoblinTraderModel(context.m_174023_(GoblinModelLayers.GOBLIN_TRADER)), 0.5f);
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.m_234598_()));
    }

    public ResourceLocation getTextureLocation(AbstractGoblinEntity entity) {
        return entity.getTexture();
    }

    protected void setupRotations(AbstractGoblinEntity entity, PoseStack pose, float ageInTicks, float rotationYaw, float partialTicks) {
        super.m_7523_((LivingEntity)entity, pose, ageInTicks, rotationYaw, partialTicks);
        ((GoblinTraderModel)this.f_115290_).headTilt = entity.getHeadTilt(partialTicks);
        ((GoblinTraderModel)this.f_115290_).armAngle = entity.getArmAngle(partialTicks);
    }

    public void render(AbstractGoblinEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource source, int light) {
        poseStack.m_85836_();
        if (entity.m_6117_() || entity.isSitting()) {
            poseStack.m_85837_(0.0, -0.17, 0.0);
        }
        if (entity.isStunned() && entity.m_6084_()) {
            float progress = Math.min(10.0f, (float)entity.getFallCounter() + partialTicks) / 10.0f;
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-entity.getStunRotation()));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f * progress));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(entity.getStunRotation()));
        }
        super.m_7392_((Mob)entity, 0.0f, partialTicks, poseStack, source, light);
        poseStack.m_85849_();
    }
}

