/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFBlocks;

public class AntibuilderBlockEntity
extends BlockEntity {
    private static final int REVERT_CHANCE = 10;
    private static final int RADIUS = 4;
    private static final int DIAMETER = 9;
    private static final double PLAYER_RANGE = 16.0;
    private final RandomSource rand = RandomSource.m_216327_();
    private int tickCount;
    private boolean slowScan;
    private int ticksSinceChange;
    private BlockState[] blockData;

    public AntibuilderBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFBlockEntities.ANTIBUILDER.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AntibuilderBlockEntity te) {
        if (te.anyPlayerInRange()) {
            ++te.tickCount;
            if (level.m_5776_()) {
                double x = (float)pos.m_123341_() + level.m_213780_().m_188501_();
                double y = (float)pos.m_123342_() + level.m_213780_().m_188501_();
                double z = (float)pos.m_123343_() + level.m_213780_().m_188501_();
                level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, x, y, z, 0.0, 0.0, 0.0);
                if (te.rand.m_188503_(10) == 0) {
                    te.makeRandomOutline();
                    te.makeRandomOutline();
                    te.makeRandomOutline();
                }
            } else {
                if (te.blockData == null && level.isAreaLoaded(pos, 4)) {
                    te.captureBlockData();
                    te.slowScan = true;
                }
                if (!(te.blockData == null || te.slowScan && te.tickCount % 20 != 0)) {
                    if (te.scanAndRevertChanges()) {
                        te.slowScan = false;
                        te.ticksSinceChange = 0;
                    } else {
                        ++te.ticksSinceChange;
                        if (te.ticksSinceChange > 20) {
                            te.slowScan = true;
                        }
                    }
                }
            }
        } else {
            te.blockData = null;
            te.tickCount = 0;
        }
    }

    private void makeRandomOutline() {
        this.makeOutline(this.rand.m_188503_(12));
    }

    private void makeOutline(int outline) {
        double sx = this.m_58899_().m_123341_();
        double sy = this.m_58899_().m_123342_();
        double sz = this.m_58899_().m_123343_();
        double dx = this.m_58899_().m_123341_();
        double dy = this.m_58899_().m_123342_();
        double dz = this.m_58899_().m_123343_();
        switch (outline) {
            case 0: 
            case 8: {
                sx -= 4.0;
                dx += 5.0;
                sz -= 4.0;
                dz -= 4.0;
                break;
            }
            case 1: 
            case 9: {
                sx -= 4.0;
                dx -= 4.0;
                sz -= 4.0;
                dz += 5.0;
                break;
            }
            case 2: 
            case 10: {
                sx -= 4.0;
                dx += 5.0;
                sz += 5.0;
                dz += 5.0;
                break;
            }
            case 3: 
            case 11: {
                sx += 5.0;
                dx += 5.0;
                sz -= 4.0;
                dz += 5.0;
                break;
            }
            case 4: {
                sx -= 4.0;
                dx -= 4.0;
                sz -= 4.0;
                dz -= 4.0;
                break;
            }
            case 5: {
                sx += 5.0;
                dx += 5.0;
                sz -= 4.0;
                dz -= 4.0;
                break;
            }
            case 6: {
                sx += 5.0;
                dx += 5.0;
                sz += 5.0;
                dz += 5.0;
                break;
            }
            case 7: {
                sx -= 4.0;
                dx -= 4.0;
                sz += 5.0;
                dz += 5.0;
            }
        }
        switch (outline) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                sy += 5.0;
                dy += 5.0;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                sy -= 4.0;
                dy += 5.0;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                sy -= 4.0;
                dy -= 4.0;
            }
        }
        if (this.rand.m_188499_()) {
            this.drawParticleLine((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, dx, dy, dz);
        } else {
            this.drawParticleLine(sx, sy, sz, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5);
        }
        this.drawParticleLine(sx, sy, sz, dx, dy, dz);
    }

    private void drawParticleLine(double srcX, double srcY, double srcZ, double destX, double destY, double destZ) {
        int particles = 16;
        for (int i = 0; i < particles; ++i) {
            double trailFactor = (double)i / ((double)particles - 1.0);
            double tx = srcX + (destX - srcX) * trailFactor + (double)this.rand.m_188501_() * 0.005;
            double ty = srcY + (destY - srcY) * trailFactor + (double)this.rand.m_188501_() * 0.005;
            double tz = srcZ + (destZ - srcZ) * trailFactor + (double)this.rand.m_188501_() * 0.005;
            this.m_58904_().m_7106_((ParticleOptions)DustParticleOptions.f_123656_, tx, ty, tz, 0.0, 0.0, 0.0);
        }
    }

    private boolean scanAndRevertChanges() {
        int index = 0;
        boolean reverted = false;
        for (int x = -4; x <= 4; ++x) {
            for (int y = -4; y <= 4; ++y) {
                for (int z = -4; z <= 4; ++z) {
                    BlockState stateThere = this.m_58904_().m_8055_(this.m_58899_().m_7918_(x, y, z));
                    if (this.blockData[index].m_60734_() != stateThere.m_60734_()) {
                        if (this.revertBlock(this.m_58899_().m_7918_(x, y, z), stateThere, this.blockData[index])) {
                            reverted = true;
                        } else {
                            this.blockData[index] = stateThere;
                        }
                    }
                    ++index;
                }
            }
        }
        return reverted;
    }

    private boolean revertBlock(BlockPos pos, BlockState stateThere, BlockState replaceWith) {
        if (stateThere.m_60795_() && !replaceWith.m_280555_()) {
            return false;
        }
        if (stateThere.m_60800_((BlockGetter)this.m_58904_(), pos) < 0.0f || this.isUnrevertable(stateThere, replaceWith)) {
            return false;
        }
        if (this.rand.m_188503_(10) == 0) {
            if (!replaceWith.m_60795_()) {
                replaceWith = ((Block)TFBlocks.ANTIBUILT_BLOCK.get()).m_49966_();
            }
            if (stateThere.m_60795_()) {
                this.m_58904_().m_46796_(2001, pos, Block.m_49956_((BlockState)replaceWith));
            }
            Block.m_49902_((BlockState)stateThere, (BlockState)replaceWith, (LevelAccessor)this.m_58904_(), (BlockPos)pos, (int)2);
        }
        return true;
    }

    private boolean isUnrevertable(BlockState stateThere, BlockState replaceWith) {
        return stateThere.m_204336_(BlockTagGenerator.ANTIBUILDER_IGNORES) || replaceWith.m_204336_(BlockTagGenerator.ANTIBUILDER_IGNORES);
    }

    private void captureBlockData() {
        this.blockData = new BlockState[729];
        int index = 0;
        for (int x = -4; x <= 4; ++x) {
            for (int y = -4; y <= 4; ++y) {
                for (int z = -4; z <= 4; ++z) {
                    this.blockData[index] = this.m_58904_().m_8055_(this.m_58899_().m_7918_(x, y, z));
                    ++index;
                }
            }
        }
    }

    private boolean anyPlayerInRange() {
        return this.m_58904_().m_45914_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, 16.0);
    }
}

