/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.capabilities;

import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import twilightforest.capabilities.fan.FeatherFanCapabilityHandler;
import twilightforest.capabilities.fan.FeatherFanFallCapability;
import twilightforest.capabilities.giant_pick.GiantPickMineCapability;
import twilightforest.capabilities.giant_pick.GiantPickMineCapabilityHandler;
import twilightforest.capabilities.shield.IShieldCapability;
import twilightforest.capabilities.shield.ShieldCapabilityHandler;
import twilightforest.capabilities.teleporter_cache.TeleporterCacheCapability;
import twilightforest.capabilities.teleporter_cache.TeleporterCacheCapabilityHandler;
import twilightforest.capabilities.thrown.YetiThrowCapability;
import twilightforest.capabilities.thrown.YetiThrowCapabilityHandler;

public class CapabilityList {
    public static final Capability<TeleporterCacheCapability> TELEPORTER_CACHE = CapabilityManager.get((CapabilityToken)new CapabilityToken<TeleporterCacheCapability>(){});
    public static final Capability<IShieldCapability> SHIELDS = CapabilityManager.get((CapabilityToken)new CapabilityToken<IShieldCapability>(){});
    public static final Capability<FeatherFanFallCapability> FEATHER_FAN_FALLING = CapabilityManager.get((CapabilityToken)new CapabilityToken<FeatherFanFallCapability>(){});
    public static final Capability<YetiThrowCapability> YETI_THROWN = CapabilityManager.get((CapabilityToken)new CapabilityToken<YetiThrowCapability>(){});
    public static final Capability<GiantPickMineCapability> GIANT_PICK_MINE = CapabilityManager.get((CapabilityToken)new CapabilityToken<GiantPickMineCapability>(){});

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(TeleporterCacheCapability.class);
        event.register(IShieldCapability.class);
        event.register(FeatherFanFallCapability.class);
        event.register(YetiThrowCapability.class);
        event.register(GiantPickMineCapability.class);
    }

    public static void attachLevelCapability(AttachCapabilitiesEvent<Level> e) {
        if (((Level)e.getObject()).m_46472_().equals(Level.f_46428_)) {
            e.addCapability(TeleporterCacheCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<CompoundTag>(){
                final LazyOptional<TeleporterCacheCapability> inst = LazyOptional.of(TeleporterCacheCapabilityHandler::new);

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                    return TELEPORTER_CACHE.orEmpty(capability, this.inst.cast());
                }

                public CompoundTag serializeNBT() {
                    return (CompoundTag)((TeleporterCacheCapability)this.inst.orElseThrow(NullPointerException::new)).serializeNBT();
                }

                public void deserializeNBT(CompoundTag nbt) {
                    ((TeleporterCacheCapability)this.inst.orElseThrow(NullPointerException::new)).deserializeNBT((Tag)nbt);
                }
            });
        }
    }

    public static void attachEntityCapability(AttachCapabilitiesEvent<Entity> e) {
        Object object = e.getObject();
        if (object instanceof LivingEntity) {
            final LivingEntity living = (LivingEntity)object;
            e.addCapability(IShieldCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<CompoundTag>(){
                final LazyOptional<IShieldCapability> inst = LazyOptional.of(() -> {
                    ShieldCapabilityHandler i = new ShieldCapabilityHandler();
                    i.setEntity(living);
                    return i;
                });

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                    return SHIELDS.orEmpty(capability, this.inst.cast());
                }

                public CompoundTag serializeNBT() {
                    return (CompoundTag)((IShieldCapability)this.inst.orElseThrow(NullPointerException::new)).serializeNBT();
                }

                public void deserializeNBT(CompoundTag nbt) {
                    ((IShieldCapability)this.inst.orElseThrow(NullPointerException::new)).deserializeNBT((Tag)nbt);
                }
            });
            Object object2 = e.getObject();
            if (object2 instanceof Player) {
                final Player player = (Player)object2;
                e.addCapability(FeatherFanFallCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<CompoundTag>(){
                    private final LazyOptional<FeatherFanFallCapability> inst = LazyOptional.of(() -> {
                        FeatherFanCapabilityHandler cap = new FeatherFanCapabilityHandler();
                        cap.setEntity(player);
                        return cap;
                    });

                    public CompoundTag serializeNBT() {
                        return (CompoundTag)((FeatherFanFallCapability)this.inst.orElseThrow(NullPointerException::new)).serializeNBT();
                    }

                    public void deserializeNBT(CompoundTag nbt) {
                        ((FeatherFanFallCapability)this.inst.orElseThrow(NullPointerException::new)).deserializeNBT((Tag)nbt);
                    }

                    @NotNull
                    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                        return FEATHER_FAN_FALLING.orEmpty(cap, this.inst.cast());
                    }
                });
            }
            e.addCapability(YetiThrowCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<CompoundTag>(){
                private final LazyOptional<YetiThrowCapability> inst = LazyOptional.of(() -> {
                    YetiThrowCapabilityHandler cap = new YetiThrowCapabilityHandler();
                    cap.setEntity(living);
                    return cap;
                });

                public CompoundTag serializeNBT() {
                    return (CompoundTag)((YetiThrowCapability)this.inst.orElseThrow(NullPointerException::new)).serializeNBT();
                }

                public void deserializeNBT(CompoundTag nbt) {
                    ((YetiThrowCapability)this.inst.orElseThrow(NullPointerException::new)).deserializeNBT((Tag)nbt);
                }

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                    return YETI_THROWN.orEmpty(cap, this.inst.cast());
                }
            });
            e.addCapability(GiantPickMineCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<CompoundTag>(){
                private final LazyOptional<GiantPickMineCapability> inst = LazyOptional.of(GiantPickMineCapabilityHandler::new);

                public CompoundTag serializeNBT() {
                    return (CompoundTag)((GiantPickMineCapability)this.inst.orElseThrow(NullPointerException::new)).serializeNBT();
                }

                public void deserializeNBT(CompoundTag nbt) {
                    ((GiantPickMineCapability)this.inst.orElseThrow(NullPointerException::new)).deserializeNBT((Tag)nbt);
                }

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                    return GIANT_PICK_MINE.orEmpty(cap, this.inst.cast());
                }
            });
        }
    }
}

