/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import twilightforest.entity.monster.Yeti;

public class YetiModel<T extends Yeti>
extends HumanoidModel<T> {
    private final ModelPart leftEye;
    private final ModelPart rightEye;
    private final ModelPart angryLeftEye;
    private final ModelPart angryRightEye;

    public YetiModel(ModelPart root) {
        super(root);
        ModelPart body = root.m_171324_("body");
        this.rightEye = body.m_171324_("right_eye");
        this.leftEye = body.m_171324_("left_eye");
        this.angryRightEye = body.m_171324_("angry_right_eye");
        this.angryLeftEye = body.m_171324_("angry_left_eye");
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition partRoot = mesh.m_171576_();
        partRoot.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -8.0f, -4.0f, 0.0f, 0.0f, 0.0f), PartPose.f_171404_);
        partRoot.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171481_(-4.0f, -8.0f, -4.0f, 0.0f, 0.0f, 0.0f), PartPose.f_171404_);
        PartDefinition body = partRoot.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171481_(-10.0f, 0.0f, -6.0f, 20.0f, 26.0f, 12.0f), PartPose.m_171419_((float)0.0f, (float)-14.0f, (float)0.0f));
        body.m_171599_("mouth", CubeListBuilder.m_171558_().m_171514_(96, 6).m_171481_(-7.0f, -5.0f, -0.5f, 14.0f, 10.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)-6.0f));
        body.m_171599_("right_eye", CubeListBuilder.m_171558_().m_171514_(96, 0).m_171481_(-2.5f, -2.5f, -0.5f, 5.0f, 5.0f, 1.0f), PartPose.m_171419_((float)-5.5f, (float)4.5f, (float)-6.0f));
        body.m_171599_("left_eye", CubeListBuilder.m_171558_().m_171514_(96, 0).m_171481_(-2.5f, -2.5f, -0.5f, 5.0f, 5.0f, 1.0f), PartPose.m_171419_((float)5.5f, (float)4.5f, (float)-6.0f));
        body.m_171599_("angry_right_eye", CubeListBuilder.m_171558_().m_171514_(109, 0).m_171481_(-2.5f, -2.5f, -0.5f, 5.0f, 5.0f, 1.0f), PartPose.m_171419_((float)5.5f, (float)4.5f, (float)-6.0f));
        body.m_171599_("angry_left_eye", CubeListBuilder.m_171558_().m_171514_(109, 0).m_171481_(-2.5f, -2.5f, -0.5f, 5.0f, 5.0f, 1.0f), PartPose.m_171419_((float)-5.5f, (float)4.5f, (float)-6.0f));
        partRoot.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-5.0f, -2.0f, -3.0f, 6.0f, 16.0f, 6.0f), PartPose.m_171419_((float)-11.0f, (float)-4.0f, (float)0.0f));
        partRoot.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171480_().m_171514_(0, 0).m_171481_(-1.0f, -2.0f, -3.0f, 6.0f, 16.0f, 6.0f), PartPose.m_171419_((float)11.0f, (float)-4.0f, (float)0.0f));
        partRoot.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171481_(-4.0f, 0.0f, -4.0f, 8.0f, 12.0f, 8.0f), PartPose.m_171419_((float)-6.0f, (float)12.0f, (float)0.0f));
        partRoot.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171480_().m_171514_(0, 22).m_171481_(-4.0f, 0.0f, -4.0f, 8.0f, 12.0f, 8.0f), PartPose.m_171419_((float)6.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.f_102808_.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.f_102808_.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.f_102809_.f_104204_ = this.f_102808_.f_104204_;
        this.f_102809_.f_104203_ = this.f_102808_.f_104203_;
        this.f_102811_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        this.f_102812_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
        this.f_102811_.f_104205_ = 0.0f;
        this.f_102812_.f_104205_ = 0.0f;
        this.f_102813_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.f_102814_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.f_102813_.f_104204_ = 0.0f;
        this.f_102814_.f_104204_ = 0.0f;
        if (entity.m_20160_()) {
            this.f_102811_.f_104203_ += (float)Math.PI;
            this.f_102812_.f_104203_ += (float)Math.PI;
        }
        if (this.f_102815_ != HumanoidModel.ArmPose.EMPTY) {
            this.f_102812_.f_104203_ = this.f_102812_.f_104203_ * 0.5f - 0.31415927f;
        }
        if (this.f_102816_ != HumanoidModel.ArmPose.EMPTY) {
            this.f_102811_.f_104203_ = this.f_102811_.f_104203_ * 0.5f - 0.31415927f;
        }
        this.f_102811_.f_104204_ = 0.0f;
        this.f_102812_.f_104204_ = 0.0f;
        this.f_102811_.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.f_102812_.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.f_102811_.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f;
        this.f_102812_.f_104203_ -= Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f;
        if (((Yeti)entity).isAngry()) {
            float f6 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI));
            float f7 = Mth.m_14031_((float)((1.0f - (1.0f - this.f_102608_) * (1.0f - this.f_102608_)) * (float)Math.PI));
            this.f_102811_.f_104205_ = 0.0f;
            this.f_102812_.f_104205_ = 0.0f;
            this.f_102811_.f_104204_ = -(0.1f - f6 * 0.6f);
            this.f_102812_.f_104204_ = 0.1f - f6 * 0.6f;
            this.f_102811_.f_104203_ = -1.5707964f;
            this.f_102812_.f_104203_ = -1.5707964f;
            this.f_102811_.f_104203_ -= f6 * 1.2f - f7 * 0.4f;
            this.f_102812_.f_104203_ -= f6 * 1.2f - f7 * 0.4f;
            this.f_102811_.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
            this.f_102812_.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
            this.f_102811_.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f;
            this.f_102812_.f_104203_ -= Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f;
        }
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        if (((Yeti)entity).isAngry()) {
            this.rightEye.f_104207_ = false;
            this.leftEye.f_104207_ = false;
            this.angryRightEye.f_104207_ = true;
            this.angryLeftEye.f_104207_ = true;
        } else {
            this.rightEye.f_104207_ = true;
            this.leftEye.f_104207_ = true;
            this.angryRightEye.f_104207_ = false;
            this.angryLeftEye.f_104207_ = false;
        }
    }
}

