/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import twilightforest.TwilightForestMod;
import twilightforest.client.model.TFModelLayers;
import twilightforest.client.model.entity.HydraMortarModel;
import twilightforest.entity.boss.HydraMortar;

public class HydraMortarRenderer
extends EntityRenderer<HydraMortar> {
    private static final ResourceLocation textureLoc = TwilightForestMod.getModelTexture("hydramortar.png");
    private final HydraMortarModel mortarModel;

    public HydraMortarRenderer(EntityRendererProvider.Context manager) {
        super(manager);
        this.f_114477_ = 0.5f;
        this.mortarModel = new HydraMortarModel(manager.m_174023_(TFModelLayers.HYDRA_MORTAR));
    }

    public void render(HydraMortar mortar, float yaw, float partialTicks, PoseStack stack, MultiBufferSource buffers, int light) {
        stack.m_85836_();
        if ((float)mortar.fuse - partialTicks + 1.0f < 10.0f) {
            float f = 1.0f - ((float)mortar.fuse - partialTicks + 1.0f) / 10.0f;
            f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
            f *= f;
            f *= f;
            float f1 = 1.0f + f * 0.3f;
            stack.m_85841_(f1, f1, f1);
        }
        float alpha = (1.0f - ((float)mortar.fuse - partialTicks + 1.0f) / 100.0f) * 0.8f;
        VertexConsumer builder = buffers.m_6299_(this.mortarModel.m_103119_(textureLoc));
        this.mortarModel.m_7695_(stack, builder, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.075f);
        if (mortar.fuse / 5 % 2 == 0) {
            builder = buffers.m_6299_(RenderType.m_110473_((ResourceLocation)textureLoc));
            this.mortarModel.m_7695_(stack, builder, light, OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)1.0f), (int)10), 1.0f, 1.0f, 1.0f, alpha);
        }
        stack.m_85849_();
    }

    public ResourceLocation getTextureLocation(HydraMortar entity) {
        return textureLoc;
    }
}

