/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import twilightforest.client.model.TFModelLayers;
import twilightforest.client.model.armor.TFArmorModel;
import twilightforest.init.TFItems;

public class ArcticArmorItem
extends ArmorItem
implements DyeableLeatherItem {
    private static final MutableComponent TOOLTIP = Component.m_237115_((String)"item.twilightforest.arctic_armor.desc").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY));

    public ArcticArmorItem(ArmorMaterial armorMaterial, ArmorItem.Type type, Item.Properties properties) {
        super(armorMaterial, type, properties);
    }

    public String getArmorTexture(ItemStack itemstack, Entity entity, EquipmentSlot slot, @Nullable String layer) {
        if (slot == EquipmentSlot.LEGS) {
            return "twilightforest:textures/armor/arcticarmor_2" + (layer == null ? "_dyed" : "_overlay") + ".png";
        }
        return "twilightforest:textures/armor/arcticarmor_1" + (layer == null ? "_dyed" : "_overlay") + ".png";
    }

    public boolean m_41113_(ItemStack stack) {
        CompoundTag CompoundNBT = stack.m_41783_();
        return CompoundNBT != null && CompoundNBT.m_128425_("display", 10) && CompoundNBT.m_128469_("display").m_128425_("color", 3);
    }

    public int m_41121_(ItemStack stack) {
        return this.getColor(stack, 1);
    }

    public void m_41123_(ItemStack stack) {
        this.removeColor(stack);
    }

    public int getColor(ItemStack stack, int type) {
        CompoundTag displayCompound;
        String string = "";
        CompoundTag stackTagCompound = stack.m_41783_();
        int color = 12439513;
        if (stackTagCompound != null && (displayCompound = stackTagCompound.m_128469_("display")).m_128425_("color" + string, 3)) {
            color = displayCompound.m_128451_("color" + string);
        }
        if (type == 0) {
            return 0xFFFFFF;
        }
        return color;
    }

    public void removeColor(ItemStack stack) {
        String string = "";
        CompoundTag stackTagCompound = stack.m_41783_();
        if (stackTagCompound != null) {
            CompoundTag displayCompound = stackTagCompound.m_128469_("display");
            if (displayCompound.m_128441_("color" + string)) {
                displayCompound.m_128473_("color" + string);
            }
            if (displayCompound.m_128441_("hasColor")) {
                displayCompound.m_128379_("hasColor", false);
            }
        }
    }

    public void m_41115_(ItemStack stack, int color) {
        String string = "";
        CompoundTag stackTagCompound = stack.m_41783_();
        if (stackTagCompound == null) {
            stackTagCompound = new CompoundTag();
            stack.m_41751_(stackTagCompound);
        }
        CompoundTag displayCompound = stackTagCompound.m_128469_("display");
        if (!stackTagCompound.m_128425_("display", 10)) {
            stackTagCompound.m_128365_("display", (Tag)displayCompound);
        }
        displayCompound.m_128405_("color" + string, color);
        displayCompound.m_128379_("hasColor", true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, level, tooltip, flagIn);
        tooltip.add((Component)TOOLTIP);
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return stack.m_150930_((Item)TFItems.ARCTIC_BOOTS.get());
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(ArmorRender.INSTANCE);
    }

    private static final class ArmorRender
    implements IClientItemExtensions {
        private static final ArmorRender INSTANCE = new ArmorRender();

        private ArmorRender() {
        }

        @NotNull
        public HumanoidModel<?> getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> model) {
            EntityModelSet models = Minecraft.m_91087_().m_167973_();
            ModelPart root = models.m_171103_(slot == EquipmentSlot.LEGS ? TFModelLayers.ARCTIC_ARMOR_INNER : TFModelLayers.ARCTIC_ARMOR_OUTER);
            return new TFArmorModel(root);
        }
    }
}

