/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;
import twilightforest.TFMagicMapData;
import twilightforest.init.TFBiomes;
import twilightforest.init.TFItems;
import twilightforest.init.TFLandmark;
import twilightforest.util.LegacyLandmarkPlacements;
import twilightforest.world.registration.TFGenerationSettings;

public class MagicMapItem
extends MapItem {
    public static final String STR_ID = "magicmap";
    private static final Map<ResourceLocation, MapColorBrightness> BIOME_COLORS = new HashMap<ResourceLocation, MapColorBrightness>();
    private static final Map<ChunkPos, ResourceLocation[]> CACHE = new HashMap<ChunkPos, ResourceLocation[]>();
    private static final ResourceLocation NULL_BIOME = new ResourceLocation("null");

    public MagicMapItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack setupNewMap(Level level, int worldX, int worldZ, byte scale, boolean trackingPosition, boolean unlimitedTracking) {
        ItemStack itemstack = new ItemStack((ItemLike)TFItems.FILLED_MAGIC_MAP.get());
        MagicMapItem.createMapData(itemstack, level, worldX, worldZ, scale, trackingPosition, unlimitedTracking, (ResourceKey<Level>)level.m_46472_());
        return itemstack;
    }

    @Nullable
    public static TFMagicMapData getData(ItemStack stack, Level level) {
        Integer id = MagicMapItem.m_151131_((ItemStack)stack);
        return id == null ? null : TFMagicMapData.getMagicMapData(level, MagicMapItem.getMapName(id));
    }

    @Nullable
    protected TFMagicMapData getCustomMapData(ItemStack stack, Level level) {
        TFMagicMapData mapdata = MagicMapItem.getData(stack, level);
        if (mapdata == null && !level.m_5776_()) {
            mapdata = MagicMapItem.createMapData(stack, level, level.m_6106_().m_6789_(), level.m_6106_().m_6526_(), 3, false, false, (ResourceKey<Level>)level.m_46472_());
        }
        return mapdata;
    }

    public static ColumnPos getMagicMapCenter(int x, int z) {
        int mapSize = 2048;
        int roundX = (int)Math.round((double)(x - 1024) / (double)mapSize);
        int roundZ = (int)Math.round((double)(z - 1024) / (double)mapSize);
        int scaledX = roundX * mapSize + 1024;
        int scaledZ = roundZ * mapSize + 1024;
        return new ColumnPos(scaledX, scaledZ);
    }

    private static TFMagicMapData createMapData(ItemStack stack, Level level, int x, int z, int scale, boolean trackingPosition, boolean unlimitedTracking, ResourceKey<Level> dimension) {
        int i = level.m_7354_();
        ColumnPos pos = MagicMapItem.getMagicMapCenter(x, z);
        TFMagicMapData mapdata = new TFMagicMapData(pos.f_140723_(), pos.f_140724_(), (byte)scale, trackingPosition, unlimitedTracking, false, dimension);
        TFMagicMapData.registerMagicMapData(level, mapdata, MagicMapItem.getMapName(i));
        stack.m_41784_().m_128405_("map", i);
        return mapdata;
    }

    public static String getMapName(int id) {
        return "magicmap_" + id;
    }

    public void m_42893_(Level level, Entity viewer, MapItemSavedData data) {
        ServerLevel serverLevel;
        if (level.m_46472_() == data.f_77887_ && viewer instanceof Player && level instanceof ServerLevel && TFGenerationSettings.usesTwilightChunkGenerator(serverLevel = (ServerLevel)level)) {
            int biomesPerPixel = 4;
            int blocksPerPixel = 16;
            int centerX = data.f_256718_;
            int centerZ = data.f_256789_;
            int viewerX = Mth.m_14107_((double)(viewer.m_20185_() - (double)centerX)) / blocksPerPixel + 64;
            int viewerZ = Mth.m_14107_((double)(viewer.m_20189_() - (double)centerZ)) / blocksPerPixel + 64;
            int viewRadiusPixels = 512 / blocksPerPixel;
            int startX = (centerX / blocksPerPixel - 64) * biomesPerPixel;
            int startZ = (centerZ / blocksPerPixel - 64) * biomesPerPixel;
            ResourceLocation[] biomes = CACHE.computeIfAbsent(new ChunkPos(startX, startZ), pos -> {
                ResourceLocation[] array = new ResourceLocation[128 * biomesPerPixel * 128 * biomesPerPixel];
                for (int l = 0; l < 128 * biomesPerPixel; ++l) {
                    for (int i1 = 0; i1 < 128 * biomesPerPixel; ++i1) {
                        array[l * 128 * biomesPerPixel + i1] = level.m_204166_(new BlockPos(startX * biomesPerPixel + i1 * biomesPerPixel, 0, startZ * biomesPerPixel + l * biomesPerPixel)).m_203543_().map(ResourceKey::m_135782_).orElse(NULL_BIOME);
                    }
                }
                return array;
            });
            for (int xPixel = viewerX - viewRadiusPixels + 1; xPixel < viewerX + viewRadiusPixels; ++xPixel) {
                for (int zPixel = viewerZ - viewRadiusPixels - 1; zPixel < viewerZ + viewRadiusPixels; ++zPixel) {
                    int worldZ;
                    int worldX;
                    if (xPixel < 0 || zPixel < 0 || xPixel >= 128 || zPixel >= 128) continue;
                    int xPixelDist = xPixel - viewerX;
                    int zPixelDist = zPixel - viewerZ;
                    boolean shouldFuzz = xPixelDist * xPixelDist + zPixelDist * zPixelDist > (viewRadiusPixels - 2) * (viewRadiusPixels - 2);
                    ResourceLocation biome = biomes[xPixel * biomesPerPixel + zPixel * biomesPerPixel * 128 * biomesPerPixel];
                    ResourceLocation overBiome = biomes[xPixel * biomesPerPixel + zPixel * biomesPerPixel * 128 * biomesPerPixel + 1];
                    ResourceLocation downBiome = biomes[xPixel * biomesPerPixel + (zPixel * biomesPerPixel + 1) * 128 * biomesPerPixel];
                    biome = overBiome != null && TFBiomes.STREAM.m_135782_().equals((Object)overBiome) ? overBiome : (downBiome != null && TFBiomes.STREAM.m_135782_().equals((Object)downBiome) ? downBiome : biome);
                    MapColorBrightness colorBrightness = this.getMapColorPerBiome(biome);
                    MapColor mapcolor = colorBrightness.color;
                    int brightness = colorBrightness.brightness;
                    if (xPixelDist * xPixelDist + zPixelDist * zPixelDist >= viewRadiusPixels * viewRadiusPixels || shouldFuzz && (xPixel + zPixel & 1) == 0) continue;
                    byte orgPixel = data.f_77891_[xPixel + zPixel * 128];
                    byte ourPixel = (byte)(mapcolor.f_283805_ * 4 + brightness);
                    if (orgPixel != ourPixel) {
                        data.m_164803_(xPixel, zPixel, ourPixel);
                        data.m_77762_();
                    }
                    if (!LegacyLandmarkPlacements.blockIsInLandmarkCenter(worldX = (centerX / blocksPerPixel + xPixel - 64) * blocksPerPixel, worldZ = (centerZ / blocksPerPixel + zPixel - 64) * blocksPerPixel)) continue;
                    byte mapX = (byte)((float)(worldX - centerX) / (float)blocksPerPixel * 2.0f);
                    byte mapZ = (byte)((float)(worldZ - centerZ) / (float)blocksPerPixel * 2.0f);
                    TFLandmark feature = LegacyLandmarkPlacements.pickLandmarkAtBlock(worldX, worldZ, (WorldGenLevel)((ServerLevel)level));
                    TFMagicMapData tfData = (TFMagicMapData)data;
                    tfData.tfDecorations.add(new TFMagicMapData.TFMapDecoration(feature, mapX, mapZ, 8));
                }
            }
        }
    }

    private MapColorBrightness getMapColorPerBiome(ResourceLocation biome) {
        if (BIOME_COLORS.isEmpty()) {
            MagicMapItem.setupBiomeColors();
        }
        if (biome == NULL_BIOME) {
            return new MapColorBrightness(MapColor.f_283927_);
        }
        MapColorBrightness color = BIOME_COLORS.get(biome);
        if (color != null) {
            return color;
        }
        return new MapColorBrightness(MapColor.f_283931_);
    }

    private static void setupBiomeColors() {
        MagicMapItem.putBiomeColor(TFBiomes.FOREST, new MapColorBrightness(MapColor.f_283915_, 1));
        MagicMapItem.putBiomeColor(TFBiomes.DENSE_FOREST, new MapColorBrightness(MapColor.f_283915_, 0));
        MagicMapItem.putBiomeColor(TFBiomes.LAKE, new MapColorBrightness(MapColor.f_283864_, 3));
        MagicMapItem.putBiomeColor(TFBiomes.STREAM, new MapColorBrightness(MapColor.f_283864_, 1));
        MagicMapItem.putBiomeColor(TFBiomes.SWAMP, new MapColorBrightness(MapColor.f_283821_, 3));
        MagicMapItem.putBiomeColor(TFBiomes.FIRE_SWAMP, new MapColorBrightness(MapColor.f_283820_, 1));
        MagicMapItem.putBiomeColor(TFBiomes.CLEARING, new MapColorBrightness(MapColor.f_283824_, 2));
        MagicMapItem.putBiomeColor(TFBiomes.OAK_SAVANNAH, new MapColorBrightness(MapColor.f_283824_, 0));
        MagicMapItem.putBiomeColor(TFBiomes.HIGHLANDS, new MapColorBrightness(MapColor.f_283762_, 0));
        MagicMapItem.putBiomeColor(TFBiomes.THORNLANDS, new MapColorBrightness(MapColor.f_283825_, 3));
        MagicMapItem.putBiomeColor(TFBiomes.FINAL_PLATEAU, new MapColorBrightness(MapColor.f_283779_, 2));
        MagicMapItem.putBiomeColor(TFBiomes.FIREFLY_FOREST, new MapColorBrightness(MapColor.f_283812_, 1));
        MagicMapItem.putBiomeColor(TFBiomes.DARK_FOREST, new MapColorBrightness(MapColor.f_283784_, 3));
        MagicMapItem.putBiomeColor(TFBiomes.DARK_FOREST_CENTER, new MapColorBrightness(MapColor.f_283750_, 3));
        MagicMapItem.putBiomeColor(TFBiomes.SNOWY_FOREST, new MapColorBrightness(MapColor.f_283811_, 1));
        MagicMapItem.putBiomeColor(TFBiomes.GLACIER, new MapColorBrightness(MapColor.f_283828_, 1));
        MagicMapItem.putBiomeColor(TFBiomes.MUSHROOM_FOREST, new MapColorBrightness(MapColor.f_283750_, 0));
        MagicMapItem.putBiomeColor(TFBiomes.DENSE_MUSHROOM_FOREST, new MapColorBrightness(MapColor.f_283765_, 0));
        MagicMapItem.putBiomeColor(TFBiomes.ENCHANTED_FOREST, new MapColorBrightness(MapColor.f_283772_, 2));
        MagicMapItem.putBiomeColor(TFBiomes.SPOOKY_FOREST, new MapColorBrightness(MapColor.f_283889_, 0));
    }

    private static void putBiomeColor(ResourceKey<Biome> biome, MapColorBrightness color) {
        BIOME_COLORS.put(biome.m_135782_(), color);
    }

    public static int getBiomeColor(Level level, Biome biome) {
        MapColorBrightness c;
        if (BIOME_COLORS.isEmpty()) {
            MagicMapItem.setupBiomeColors();
        }
        return (c = BIOME_COLORS.get(level.m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)biome))) != null ? MagicMapItem.getMapColor(c) : -16777216;
    }

    public static int getMapColor(MapColorBrightness mcb) {
        int i = switch (mcb.color.f_283805_) {
            case 3 -> 135;
            case 2 -> 255;
            case 0 -> 180;
            default -> 220;
        };
        int j = (mcb.color.f_283871_ >> 16 & 0xFF) * i / 255;
        int k = (mcb.color.f_283871_ >> 8 & 0xFF) * i / 255;
        int l = (mcb.color.f_283871_ & 0xFF) * i / 255;
        return 0xFF000000 | l << 16 | k << 8 | j;
    }

    public void m_7836_(ItemStack stack, Level world, Player player) {
    }

    @Nullable
    public Packet<?> m_7233_(ItemStack stack, Level world, Player player) {
        Integer id = MagicMapItem.m_151131_((ItemStack)stack);
        TFMagicMapData mapdata = this.getCustomMapData(stack, world);
        return id == null || mapdata == null ? null : mapdata.m_164796_(id, player);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        TFMagicMapData mapitemsaveddata;
        Integer integer = MagicMapItem.m_151131_((ItemStack)stack);
        TFMagicMapData tFMagicMapData = mapitemsaveddata = level == null ? null : MagicMapItem.getData(stack, level);
        if (flag.m_7050_()) {
            if (mapitemsaveddata != null) {
                tooltip.add((Component)Component.m_237110_((String)"filled_map.id", (Object[])new Object[]{integer}).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237110_((String)"filled_map.scale", (Object[])new Object[]{1 << mapitemsaveddata.f_77890_}).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237110_((String)"filled_map.level", (Object[])new Object[]{mapitemsaveddata.f_77890_, 4}).m_130940_(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"filled_map.unknown").m_130940_(ChatFormatting.GRAY));
            }
        } else if (integer != null) {
            tooltip.add((Component)Component.m_237113_((String)("#" + integer)).m_130940_(ChatFormatting.GRAY));
        }
    }

    private static class MapColorBrightness {
        public final MapColor color;
        public final int brightness;

        public MapColorBrightness(MapColor color, int brightness) {
            this.color = color;
            this.brightness = brightness;
        }

        public MapColorBrightness(MapColor color) {
            this.color = color;
            this.brightness = 1;
        }
    }
}

