/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.network.NetworkEvent;
import twilightforest.entity.ProtectionBox;
import twilightforest.init.TFParticleType;

public class AreaProtectionPacket {
    private final List<BoundingBox> sbb;
    private final BlockPos pos;

    public AreaProtectionPacket(List<BoundingBox> sbb, BlockPos pos) {
        this.sbb = sbb;
        this.pos = pos;
    }

    public AreaProtectionPacket(FriendlyByteBuf buf) {
        this.sbb = new ArrayList<BoundingBox>();
        int len = buf.readInt();
        for (int i = 0; i < len; ++i) {
            this.sbb.add(new BoundingBox(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt()));
        }
        this.pos = buf.m_130135_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.sbb.size());
        this.sbb.forEach(box -> {
            buf.writeInt(box.m_162395_());
            buf.writeInt(box.m_162396_());
            buf.writeInt(box.m_162398_());
            buf.writeInt(box.m_162399_());
            buf.writeInt(box.m_162400_());
            buf.writeInt(box.m_162401_());
        });
        buf.m_130064_(this.pos);
    }

    public static class Handler {
        public static boolean onMessage(final AreaProtectionPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    ClientLevel level = Minecraft.m_91087_().f_91073_;
                    message.sbb.forEach(box -> 1.addProtectionBox(level, box));
                    for (int i = 0; i < 20; ++i) {
                        double vx = level.m_213780_().m_188583_() * 0.02;
                        double vy = level.m_213780_().m_188583_() * 0.02;
                        double vz = level.m_213780_().m_188583_() * 0.02;
                        double x = (double)message.pos.m_123341_() + 0.5 + (double)level.m_213780_().m_188501_() - (double)level.m_213780_().m_188501_();
                        double y = (double)message.pos.m_123342_() + 0.5 + (double)level.m_213780_().m_188501_() - (double)level.m_213780_().m_188501_();
                        double z = (double)message.pos.m_123343_() + 0.5 + (double)level.m_213780_().m_188501_() - (double)level.m_213780_().m_188501_();
                        level.m_7106_((ParticleOptions)TFParticleType.PROTECTION.get(), x, y, z, vx, vy, vz);
                    }
                }

                static void addProtectionBox(ClientLevel level, BoundingBox sbb) {
                    for (Entity entity : level.m_104735_()) {
                        if (!(entity instanceof ProtectionBox)) continue;
                        ProtectionBox box = (ProtectionBox)entity;
                        if (box.lifeTime <= 0 || !box.matches(sbb)) continue;
                        box.resetLifetime();
                        return;
                    }
                    level.m_104627_(0, (Entity)new ProtectionBox((Level)level, sbb));
                }
            });
            ctx.get().setPacketHandled(true);
            return true;
        }
    }
}

