/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.network.NetworkEvent;
import twilightforest.TFMazeMapData;
import twilightforest.item.MazeMapItem;

public class MazeMapPacket {
    private final ClientboundMapItemDataPacket inner;
    private final boolean ore;
    private final int yCenter;

    public MazeMapPacket(ClientboundMapItemDataPacket inner, boolean ore, int yCenter) {
        this.inner = inner;
        this.ore = ore;
        this.yCenter = yCenter;
    }

    public MazeMapPacket(FriendlyByteBuf buf) {
        this.inner = new ClientboundMapItemDataPacket(buf);
        this.ore = buf.readBoolean();
        this.yCenter = buf.m_130242_();
    }

    public void encode(FriendlyByteBuf buf) {
        this.inner.m_5779_(buf);
        buf.writeBoolean(this.ore);
        buf.m_130130_(this.yCenter);
    }

    public static class Handler {
        public static boolean onMessage(final MazeMapPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    MapRenderer mapitemrenderer = Minecraft.m_91087_().f_91063_.m_109151_();
                    String s = MazeMapItem.getMapName(message.inner.m_132445_());
                    TFMazeMapData mapdata = TFMazeMapData.getMazeMapData((Level)Minecraft.m_91087_().f_91073_, s);
                    if (mapdata == null) {
                        mapdata = new TFMazeMapData(0, 0, message.inner.m_178982_(), false, false, message.inner.m_178983_(), (ResourceKey<Level>)Minecraft.m_91087_().f_91073_.m_46472_());
                        TFMazeMapData.registerMazeMapData((Level)Minecraft.m_91087_().f_91073_, mapdata, s);
                    }
                    mapdata.ore = message.ore;
                    mapdata.yCenter = message.yCenter;
                    message.inner.m_132437_((MapItemSavedData)mapdata);
                    mapitemrenderer.m_168765_(message.inner.m_132445_(), (MapItemSavedData)mapdata);
                }
            });
            ctx.get().setPacketHandled(true);
            return true;
        }
    }
}

