/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import twilightforest.block.FallenLeavesBlock;
import twilightforest.init.TFBlocks;

public class FallenLeavesFeature
extends Feature<NoneFeatureConfiguration> {
    private final BlockState state = ((Block)TFBlocks.FALLEN_LEAVES.get()).m_49966_();

    public FallenLeavesFeature(Codec<NoneFeatureConfiguration> config) {
        super(config);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        WorldGenLevel level = ctx.m_159774_();
        BlockPos position = level.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, ctx.m_159777_());
        RandomSource rand = ctx.m_225041_();
        if (this.canPlace(position, level)) {
            if (!level.m_6425_(position.m_7495_()).m_76178_()) {
                return this.generateFlatPileOnWater(level, position, rand);
            }
            int startHeight = rand.m_188503_(6) + 1;
            level.m_7731_(position, (BlockState)this.state.m_61124_((Property)FallenLeavesBlock.LAYERS, (Comparable)Integer.valueOf(startHeight)), 18);
            for (int i = 0; i < startHeight; ++i) {
                this.generateCircleOfLeaves(level, position, rand, i, startHeight - i - 1);
                if (rand.m_188503_(3) != 0) continue;
                ++i;
            }
            return true;
        }
        return false;
    }

    private boolean generateFlatPileOnWater(WorldGenLevel level, BlockPos pos, RandomSource random) {
        for (int x = 0; x < 5; ++x) {
            for (int z = 0; z < 5; ++z) {
                BlockPos finalPos;
                if (random.m_188503_(3) != 0) continue;
                boolean flag = false;
                int y = 2;
                do {
                    if (!this.canPlace(pos.m_7918_(x, y, z), level)) continue;
                    flag = true;
                    break;
                } while (--y >= -2);
                if (!flag || !this.state.m_60710_((LevelReader)level, finalPos = pos.m_7918_(x, y, z))) continue;
                level.m_7731_(finalPos, this.state, 18);
            }
        }
        return true;
    }

    private void generateCircleOfLeaves(WorldGenLevel level, BlockPos origin, RandomSource random, int radius, int height) {
        for (int i1 = origin.m_123341_() - radius; i1 <= origin.m_123341_() + radius; ++i1) {
            for (int j1 = origin.m_123343_() - radius; j1 <= origin.m_123343_() + radius; ++j1) {
                int l1;
                int k1 = i1 - origin.m_123341_();
                if (k1 * k1 + (l1 = j1 - origin.m_123343_()) * l1 > radius * radius) continue;
                BlockPos newPos = new BlockPos(i1, origin.m_123342_(), j1);
                int trueHeight = height - random.m_188503_(3);
                if (trueHeight <= 0) continue;
                this.checkAndGenerateLeafPile(level, newPos, trueHeight);
            }
        }
    }

    private void checkAndGenerateLeafPile(WorldGenLevel level, BlockPos pos, int pileLayer) {
        boolean flag = false;
        int y = 0;
        do {
            if (!this.canPlace(pos.m_7918_(0, y, 0), level)) continue;
            flag = true;
            break;
        } while (--y >= -2);
        if (!flag) {
            return;
        }
        BlockPos finalPos = pos.m_7918_(0, y, 0);
        if (this.state.m_60734_().m_7898_(this.state, (LevelReader)level, finalPos)) {
            level.m_7731_(finalPos, (BlockState)this.state.m_61124_((Property)FallenLeavesBlock.LAYERS, (Comparable)Integer.valueOf(pileLayer)), 18);
        }
    }

    private boolean canPlace(BlockPos pos, WorldGenLevel level) {
        BlockState state = level.m_8055_(pos.m_7495_());
        return !(level.m_8055_(pos).m_60713_(this.state.m_60734_()) || !level.m_46859_(pos) && !level.m_8055_(pos).m_60713_((Block)TFBlocks.MAYAPPLE.get()) && !level.m_8055_(pos).m_247087_() || !state.m_204336_(BlockTags.f_144274_) && !level.m_6425_(pos.m_7495_()).m_192917_((Fluid)Fluids.f_76193_));
    }
}

