/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.mushroomtower;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.lichtower.TowerRoofComponent;
import twilightforest.world.components.structures.lichtower.TowerWingComponent;

public class TowerRoofMushroomComponent
extends TowerRoofComponent {
    public TowerRoofMushroomComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super((StructurePieceType)TFStructurePieceTypes.TFMTRoofMush.get(), nbt);
    }

    public TowerRoofMushroomComponent(int i, TowerWingComponent wing, float pHang, int x, int y, int z) {
        super((StructurePieceType)TFStructurePieceTypes.TFMTRoofMush.get(), i, x, y, z);
        this.height = wing.size;
        int overhang = (int)((float)this.height * pHang);
        this.size = this.height + overhang * 2;
        this.m_73519_(Direction.SOUTH);
        this.f_73383_ = new BoundingBox(wing.m_73547_().m_162395_() - overhang, wing.m_73547_().m_162400_() + 2, wing.m_73547_().m_162398_() - overhang, wing.m_73547_().m_162399_() + overhang, wing.m_73547_().m_162400_() + this.height + 1, wing.m_73547_().m_162401_() + overhang);
    }

    public void m_214092_(StructurePiece parent, StructurePieceAccessor list, RandomSource rand) {
        if (parent != null && parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
    }

    @Override
    public void m_213694_(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        for (int y = 0; y <= this.height; ++y) {
            int radius = (int)(Mth.m_14031_((float)(((float)y + (float)this.height / 1.2f) / ((float)this.height * 2.05f) * 3.14f)) * (float)this.size / 2.0f);
            int hollow = Mth.m_14143_((float)((float)radius * 0.9f));
            if (this.height - y < 3) {
                hollow = -1;
            }
            this.makeCircle(world, y, radius, hollow, sbb);
        }
    }

    private void makeCircle(WorldGenLevel world, int y, int radius, int hollow, BoundingBox sbb) {
        int cx = this.size / 2;
        int cz = this.size / 2;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                float dist = Mth.m_14116_((float)(dx * dx + dz * dz));
                if (!(dist <= (float)radius + 0.5f)) continue;
                if (dist > (float)hollow) {
                    this.m_73434_(world, this.deco.accentState, dx + cx, y, dz + cz, sbb);
                    continue;
                }
                this.m_73434_(world, this.deco.accentState.m_60734_().m_49966_(), dx + cx, y, dz + cz, sbb);
            }
        }
    }
}

