/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import org.jetbrains.annotations.Nullable;

public record DispelEntityRecipe(ResourceLocation id, EntityType<?> entity, ResourceLocation lootTable, LootItemCondition[] conditions) implements Recipe<Container>
{
    public boolean m_5818_(Container container, Level level) {
        return false;
    }

    public boolean matches(LivingEntity killer, Entity victim) {
        if (!victim.m_6095_().equals(this.entity)) {
            return false;
        }
        if (this.conditions.length == 0) {
            return true;
        }
        LootParams params = this.getLootParams(killer, victim);
        LootContext context = new LootContext.Builder(params).m_287259_(null);
        return Arrays.stream(this.conditions).allMatch(condition -> condition.test((Object)context));
    }

    private LootParams getLootParams(LivingEntity killer, Entity victim) {
        LootParams.Builder params = new LootParams.Builder((ServerLevel)victim.f_19853_).m_287286_(LootContextParams.f_81460_, (Object)victim.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)victim).m_287286_(LootContextParams.f_81457_, (Object)killer.m_269291_().m_269333_(killer)).m_287289_(LootContextParams.f_81458_, (Object)killer).m_287289_(LootContextParams.f_81459_, (Object)killer);
        if (killer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)killer;
            params = params.m_287289_(LootContextParams.f_81456_, (Object)serverPlayer).m_287239_(serverPlayer.m_36336_());
        }
        return params.m_287235_(LootContextParamSets.f_81415_);
    }

    public List<ItemStack> result(LivingEntity killer, Entity victim) {
        if (!victim.m_6095_().equals(this.entity)) {
            return List.of();
        }
        LootParams params = this.getLootParams(killer, victim);
        LootTable lootTable = killer.m_9236_().m_7654_().m_278653_().m_278676_(this.lootTable());
        return lootTable.m_287195_(params);
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int i, int i1) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeRegistry.DISPEL_ENTITY_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeRegistry.DISPEL_ENTITY_TYPE.get();
    }

    public boolean m_5598_() {
        return true;
    }

    public JsonElement asRecipe() {
        JsonElement recipe = Serializer.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().orElse(null);
        if (recipe == null) {
            return null;
        }
        JsonObject obj = recipe.getAsJsonObject();
        obj.addProperty("type", this.m_6671_().toString());
        return obj;
    }

    public static class Serializer
    implements RecipeSerializer<DispelEntityRecipe> {
        public static final Codec<DispelEntityRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("id").forGetter(DispelEntityRecipe::id), (App)BuiltInRegistries.f_256780_.m_194605_().fieldOf("entity").forGetter(DispelEntityRecipe::entity), (App)ResourceLocation.f_135803_.fieldOf("loot_table").forGetter(DispelEntityRecipe::lootTable), (App)IGlobalLootModifier.LOOT_CONDITIONS_CODEC.optionalFieldOf("loot_conditions", (Object)new LootItemCondition[0]).forGetter(DispelEntityRecipe::conditions)).apply((Applicative)instance, DispelEntityRecipe::new));

        public DispelEntityRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            return CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).result().orElse(null);
        }

        @Nullable
        public DispelEntityRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf friendlyByteBuf) {
            return (DispelEntityRecipe)friendlyByteBuf.m_271872_(CODEC);
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf, DispelEntityRecipe buddingConversionRecipe) {
            friendlyByteBuf.m_272073_(CODEC, (Object)buddingConversionRecipe);
        }
    }
}

