/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.common.block.tile.ScribesTile;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketSetScribeRecipe {
    BlockPos scribePos;
    ResourceLocation recipeID;

    public PacketSetScribeRecipe(FriendlyByteBuf buf) {
        this.scribePos = buf.m_130135_();
        this.recipeID = buf.m_130281_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.scribePos);
        buf.m_130085_(this.recipeID);
    }

    public PacketSetScribeRecipe(BlockPos scribesPos, ResourceLocation resourceLocation) {
        this.scribePos = scribesPos;
        this.recipeID = resourceLocation;
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            BlockEntity patt1394$temp = player.f_19853_.m_7702_(this.scribePos);
            if (patt1394$temp instanceof ScribesTile) {
                ScribesTile scribesTile = (ScribesTile)patt1394$temp;
                Recipe recipe = player.f_19853_.m_7465_().m_44043_(this.recipeID).orElse(null);
                if (recipe instanceof GlyphRecipe) {
                    GlyphRecipe glyphRecipe = (GlyphRecipe)recipe;
                    scribesTile.setRecipe(glyphRecipe, (Player)player);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

