/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.command;

import java.util.List;
import java.util.Optional;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.command.CommandArguments;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.shape.ShapeType;
import org.popcraft.chunky.util.Input;
import org.popcraft.chunky.util.Translator;

public class ShapeCommand
implements ChunkyCommand {
    private final Chunky chunky;

    public ShapeCommand(Chunky chunky) {
        this.chunky = chunky;
    }

    @Override
    public void execute(Sender sender, CommandArguments arguments) {
        Optional inputShape = arguments.next().flatMap(Input::tryShape);
        if (inputShape.isEmpty()) {
            sender.sendMessage("help_shape", new Object[0]);
            return;
        }
        String shape = (String)inputShape.get();
        this.chunky.getSelection().shape(shape);
        sender.sendMessagePrefixed("format_shape", Translator.translate("shape_" + shape, new Object[0]));
    }

    @Override
    public List<String> suggestions(CommandArguments arguments) {
        if (arguments.size() == 1) {
            return ShapeType.all();
        }
        return List.of();
    }
}

