/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.generating;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.mana.ManaSpreaderBlock;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class EndoflameBlockEntity
extends GeneratingFlowerBlockEntity {
    private static final String TAG_BURN_TIME = "burnTime";
    private static final int FUEL_CAP = 32000;
    private static final int RANGE = 3;
    private static final int START_BURN_EVENT = 0;
    private int burnTime = 0;

    public EndoflameBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.ENDOFLAME, pos, state);
    }

    @Override
    public void tickFlower() {
        boolean wasBurning;
        super.tickFlower();
        boolean bl = wasBurning = this.burnTime > 0;
        if (wasBurning) {
            --this.burnTime;
        }
        if (this.m_58904_().f_46443_) {
            if (this.burnTime > 0 && this.m_58904_().f_46441_.m_188503_(10) == 0) {
                this.emitParticle((ParticleOptions)ParticleTypes.f_123744_, 0.4 + Math.random() * 0.2, 0.7, 0.4 + Math.random() * 0.2, 0.0, 0.0, 0.0);
            }
            return;
        }
        if (this.burnTime > 0 && this.ticksExisted % 2 == 0) {
            this.addMana(3);
        }
        if (this.burnTime == 0) {
            if (this.getMana() < this.getMaxMana()) {
                for (ItemEntity item : this.m_58904_().m_45976_(ItemEntity.class, new AABB(this.getEffectivePos().m_7918_(-3, -3, -3), this.getEffectivePos().m_7918_(4, 4, 4)))) {
                    int burnTime;
                    ItemStack stack;
                    if (!DelayHelper.canInteractWith(this, item) || (stack = item.m_32055_()).m_41720_().m_41470_() || (burnTime = this.getBurnTime(stack)) <= 0 || stack.m_41613_() <= 0) continue;
                    this.burnTime = Math.min(32000, burnTime) / 2;
                    EntityHelper.shrinkItem(item);
                    this.m_58904_().m_5594_(null, this.getEffectivePos(), BotaniaSounds.endoflame, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.m_58904_().m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 0, item.m_19879_());
                    this.m_58904_().m_142346_(null, GameEvent.f_223702_, this.m_58899_());
                    this.sync();
                    return;
                }
            }
            if (wasBurning) {
                this.m_58904_().m_142346_(null, GameEvent.f_223703_, this.m_58899_());
            }
        }
    }

    public boolean m_7531_(int event, int param) {
        if (event == 0) {
            Entity e = this.m_58904_().m_6815_(param);
            if (e != null) {
                e.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, e.m_20185_(), e.m_20186_() + 0.1, e.m_20189_(), 0.0, 0.0, 0.0);
                e.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, e.m_20185_(), e.m_20186_(), e.m_20189_(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        return super.m_7531_(event, param);
    }

    @Override
    public int getMaxMana() {
        return 300;
    }

    @Override
    public int getColor() {
        return 7884800;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 3);
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_BURN_TIME, this.burnTime);
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.burnTime = cmp.m_128451_(TAG_BURN_TIME);
    }

    private int getBurnTime(ItemStack stack) {
        if (stack.m_41619_() || Block.m_49814_((Item)stack.m_41720_()) instanceof ManaSpreaderBlock) {
            return 0;
        }
        return XplatAbstractions.INSTANCE.getSmeltingBurnTime(stack);
    }
}

