/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.manasteel;

import java.util.function.Consumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.SortableTool;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.equipment.CustomDamageItem;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ManasteelHoeItem
extends HoeItem
implements CustomDamageItem,
SortableTool {
    private static final int MANA_PER_DAMAGE = 60;

    public ManasteelHoeItem(Item.Properties props) {
        this(BotaniaAPI.instance().getManasteelItemTier(), props, -1.0f);
    }

    public ManasteelHoeItem(Tier mat, Item.Properties properties, float attackSpeed) {
        super(mat, (int)(-mat.m_6631_()), attackSpeed, properties);
    }

    @Override
    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        int manaPer = ((ManasteelHoeItem)stack.m_41720_()).getManaPerDamage();
        return ToolCommons.damageItemIfPossible(stack, amount, entity, manaPer);
    }

    public int getManaPerDamage() {
        return 60;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!world.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            if (stack.m_41773_() > 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, this.getManaPerDamage() * 2, true)) {
                stack.m_41721_(stack.m_41773_() - 1);
            }
        }
    }

    @Override
    public int getSortingPriority(ItemStack stack, BlockState state) {
        return ToolCommons.getToolPriority(stack);
    }
}

