/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.block;

import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.level.block.entity.BlockEntity;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.flower.generating.DandelifeonBlockEntity;

public class DandelifeonTest {
    private static final String TEMPLATE = "botania:block/dandelifeon_transfer";
    private static final BlockPos LEVER_POS = new BlockPos(29, 2, 12);
    private static final BlockPos TARGET_POS = new BlockPos(10, 3, 11);
    private static final BlockPos LOWER_SQUARE = new BlockPos(32, 3, 11);
    private static final BlockPos UPPER_SQUARE = new BlockPos(32, 3, 12);
    private static final int EXPECTED_MANA = 2460;

    @GameTest(template="botania:block/dandelifeon_transfer", timeoutTicks=250)
    public void testDandelifeonTransferring(GameTestHelper helper) {
        helper.m_177425_().m_177562_(() -> helper.m_177421_(LEVER_POS)).m_177546_(240, () -> {
            for (int x = LOWER_SQUARE.m_123341_(); x <= UPPER_SQUARE.m_123341_(); ++x) {
                for (int y = LOWER_SQUARE.m_123342_(); y <= UPPER_SQUARE.m_123342_(); ++y) {
                    for (int z = LOWER_SQUARE.m_123343_(); z <= UPPER_SQUARE.m_123343_(); ++z) {
                        helper.m_177208_(BotaniaBlocks.cellBlock, new BlockPos(x, y, z));
                    }
                }
            }
            BlockEntity be = helper.m_177347_(TARGET_POS);
            if (!(be instanceof DandelifeonBlockEntity)) {
                throw new GameTestAssertException("Missing Dandelifeon at: " + String.valueOf(TARGET_POS));
            }
            DandelifeonBlockEntity dandie = (DandelifeonBlockEntity)be;
            int radius = dandie.getRange();
            for (int i = -radius; i <= radius; ++i) {
                for (int j = -radius; j <= radius; ++j) {
                    helper.m_177341_(BotaniaBlocks.cellBlock, new BlockPos(i + TARGET_POS.m_123341_(), TARGET_POS.m_123342_(), j + TARGET_POS.m_123343_()));
                }
            }
            if (dandie.getMana() != 2460) {
                throw new GameTestAssertException("Wrong amount of mana: expected 2460 but was " + dandie.getMana());
            }
        }).m_177543_();
    }
}

