/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.api.common.loot.condition;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.valhelsia.valhelsia_core.core.registry.ValhelsiaLootConditions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record MatchBlockCondition(@Nullable List<Block> blocks, @Nullable TagKey<Block> tag, @Nullable StatePropertiesPredicate properties) implements LootItemCondition
{
    public static LootItemCondition.Builder builder(List<Block> blocks) {
        return () -> new MatchBlockCondition(blocks, null, null);
    }

    public static LootItemCondition.Builder builder(TagKey<Block> tag) {
        return () -> new MatchBlockCondition(null, tag, null);
    }

    public static LootItemCondition.Builder builder(List<Block> blocks, TagKey<Block> tag) {
        return () -> new MatchBlockCondition(blocks, tag, null);
    }

    public static LootItemCondition.Builder builder(List<Block> blocks, TagKey<Block> tag, StatePropertiesPredicate properties) {
        return () -> new MatchBlockCondition(blocks, tag, properties);
    }

    @NotNull
    public LootItemConditionType m_7940_() {
        return ValhelsiaLootConditions.MATCH_BLOCK.get();
    }

    @NotNull
    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81461_);
    }

    public boolean test(LootContext lootContext) {
        if (!lootContext.m_78936_(LootContextParams.f_81461_)) {
            return false;
        }
        BlockState state = (BlockState)lootContext.m_165124_(LootContextParams.f_81461_);
        boolean flag = false;
        if (this.tag != null) {
            flag = state.m_204336_(this.tag);
        }
        if (this.blocks != null && !flag) {
            flag = this.blocks.contains(state.m_60734_());
        }
        if (this.properties != null) {
            flag = this.properties.m_67667_(state);
        }
        return flag;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<MatchBlockCondition> {
        public void serialize(@NotNull JsonObject jsonObject, MatchBlockCondition instance, @NotNull JsonSerializationContext context) {
            if (instance.tag != null) {
                jsonObject.addProperty("tag", instance.tag.f_203868_().toString());
            }
            if (instance.properties != null) {
                jsonObject.add("properties", instance.properties.m_67666_());
            }
        }

        @NotNull
        public MatchBlockCondition deserialize(JsonObject jsonObject, @NotNull JsonDeserializationContext context) {
            if (jsonObject.has("tag")) {
                ResourceLocation tag = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"tag"));
                return new MatchBlockCondition(null, (TagKey<Block>)TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)tag), this.deserializeProperties(jsonObject));
            }
            if (jsonObject.has("blocks")) {
                ArrayList<Block> blocks = new ArrayList<Block>();
                for (JsonElement e : GsonHelper.m_13933_((JsonObject)jsonObject, (String)"blocks")) {
                    ResourceLocation blockName = new ResourceLocation(e.getAsString());
                    blocks.add((Block)BuiltInRegistries.f_256975_.m_7745_(blockName));
                }
                return new MatchBlockCondition(blocks, null, this.deserializeProperties(jsonObject));
            }
            if (jsonObject.has("block")) {
                ResourceLocation block = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"block"));
                return new MatchBlockCondition(Collections.singletonList((Block)BuiltInRegistries.f_256975_.m_7745_(block)), null, this.deserializeProperties(jsonObject));
            }
            throw new RuntimeException("match_block must have one of 'tag', 'block' or 'blocks' key");
        }

        private StatePropertiesPredicate deserializeProperties(JsonObject jsonObject) {
            if (jsonObject.has("properties")) {
                return StatePropertiesPredicate.m_67679_((JsonElement)jsonObject.get("properties"));
            }
            return null;
        }
    }
}

