/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.api.common.loot.modifier;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class AppendLootTableModifier
extends LootModifier {
    public static final Supplier<Codec<AppendLootTableModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(instance -> AppendLootTableModifier.codecStart((RecordCodecBuilder.Instance)instance).and((App)ResourceLocation.f_135803_.fieldOf("loot_addition").forGetter(modifier -> modifier.lootTable)).apply((Applicative)instance, AppendLootTableModifier::new)));
    private final ResourceLocation lootTable;
    boolean reentryPrevention = false;

    public AppendLootTableModifier(LootItemCondition[] conditions, ResourceLocation lootTable) {
        super(conditions);
        this.lootTable = lootTable;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (this.reentryPrevention) {
            return generatedLoot;
        }
        this.reentryPrevention = true;
        LootTable lootTable = context.m_278643_().m_278676_(this.lootTable);
        lootTable.m_79148_(context, arg_0 -> generatedLoot.add(arg_0));
        this.reentryPrevention = false;
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

