/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.container.spirit;

import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import com.klikli_dev.occultism.registry.OccultismContainers;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class SpiritContainer
extends AbstractContainerMenu {
    public ItemStackHandler inventory;
    public SpiritEntity spirit;

    public SpiritContainer(int id, Inventory playerInventory, SpiritEntity spirit) {
        this((MenuType)OccultismContainers.SPIRIT.get(), id, playerInventory, spirit);
    }

    public SpiritContainer(@Nullable MenuType<?> type, int id, Inventory playerInventory, SpiritEntity spirit) {
        super(type, id);
        this.inventory = (ItemStackHandler)spirit.itemStackHandler.orElseThrow(ItemHandlerMissingException::new);
        this.spirit = spirit;
        this.setupSlots(playerInventory);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < this.inventory.getSlots() ? !this.m_38903_(itemstack1, this.inventory.getSlots(), this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.inventory.getSlots(), false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
    }

    public boolean m_6875_(Player entityPlayer) {
        return this.spirit.m_6084_() && this.spirit.m_20270_((Entity)entityPlayer) < 8.0f;
    }

    public void setupSlots(Inventory playerInventory) {
        this.setupPlayerInventorySlots(playerInventory.f_35978_);
        this.setupPlayerHotbar(playerInventory.f_35978_);
        this.setupEntityInventory();
    }

    protected void setupPlayerInventorySlots(Player player) {
        int playerInventoryTop = 84;
        int playerInventoryLeft = 8;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)player.m_150109_(), j + i * 9 + 9, playerInventoryLeft + j * 18, playerInventoryTop + i * 18));
            }
        }
    }

    protected void setupPlayerHotbar(Player player) {
        int hotbarTop = 142;
        int hotbarLeft = 8;
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)player.m_150109_(), i, hotbarLeft + i * 18, hotbarTop));
        }
    }

    protected void setupEntityInventory() {
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.inventory, 0, 152, 54){

            public boolean m_5857_(ItemStack stack) {
                return super.m_5857_(stack);
            }

            public void m_6654_() {
                this.f_40218_.m_6596_();
            }
        });
    }
}

