/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network;

import com.klikli_dev.occultism.network.IMessage;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class OccultismPacketHandler {
    public static <T extends IMessage> void handle(T message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide() == LogicalSide.SERVER) {
            ctx.get().enqueueWork(() -> OccultismPacketHandler.handleServer(message, ctx));
        } else {
            ctx.get().enqueueWork(() -> OccultismPacketHandler.handleClient(message, ctx));
        }
        ctx.get().setPacketHandled(true);
    }

    public static <T extends IMessage> void handleServer(T message, Supplier<NetworkEvent.Context> ctx) {
        MinecraftServer server = ctx.get().getSender().m_9236_().m_7654_();
        message.onServerReceived(server, ctx.get().getSender(), ctx.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <T extends IMessage> void handleClient(T message, Supplier<NetworkEvent.Context> ctx) {
        Minecraft minecraft = Minecraft.m_91087_();
        message.onClientReceived(minecraft, (Player)minecraft.f_91074_, ctx.get());
    }
}

