/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemylib.api.capability;

import com.smashingmods.alchemylib.api.capability.HeatCapability;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;

public class HeatHandler
implements HeatCapability {
    private int heat;
    private final int maxHeat;

    public HeatHandler(int pMax) {
        this.maxHeat = pMax;
    }

    @Override
    public int getHeat() {
        return this.heat;
    }

    @Override
    public void setHeat(int pHeat) {
        this.heat = pHeat;
    }

    @Override
    public void increment(int pHeat) {
        this.heat = this.heat + pHeat <= this.maxHeat ? (this.heat += pHeat) : this.maxHeat;
    }

    @Override
    public void decrement(int pHeat) {
        this.heat = this.heat - pHeat >= 0 ? (this.heat -= pHeat) : 0;
    }

    @Override
    public int getMaxHeat() {
        return this.maxHeat;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("heat", this.heat);
        return tag;
    }

    public void deserializeNBT(CompoundTag pTag) {
        this.setHeat(pTag.m_128451_("heat"));
    }

    @Override
    public Component getComponent() {
        return MutableComponent.m_237204_((ComponentContents)new LiteralContents(String.format("%s H", this.heat)));
    }

    @Override
    public String toString() {
        return String.format("[%s heat, %s max heat]", this.heat, this.maxHeat);
    }
}

