/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemylib.api.network;

import com.smashingmods.alchemylib.api.network.AlchemyPacket;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public abstract class AbstractPacketHandler {
    private int PACKET_ID;

    protected static SimpleChannel createChannel(ResourceLocation pChannelName, String pProtocolVersion) {
        return NetworkRegistry.newSimpleChannel((ResourceLocation)pChannelName, () -> pProtocolVersion, pProtocolVersion::equals, pProtocolVersion::equals);
    }

    public abstract AbstractPacketHandler register();

    protected abstract SimpleChannel getChannel();

    protected <MSG extends AlchemyPacket> void registerMessage(Class<MSG> pMessageType, Function<FriendlyByteBuf, MSG> pDecoder) {
        this.getChannel().registerMessage(this.PACKET_ID++, pMessageType, AlchemyPacket::encode, pDecoder, AlchemyPacket::handle);
    }

    public <MSG extends AlchemyPacket> void sendToServer(MSG pMessage) {
        this.getChannel().sendToServer(pMessage);
    }

    public <MSG extends AlchemyPacket> void sendToPlayer(MSG pMessage, ServerPlayer pPlayer) {
        this.getChannel().send(PacketDistributor.PLAYER.with(() -> pPlayer), pMessage);
    }

    public <MSG extends AlchemyPacket> void sendToAll(MSG pMessage) {
        this.getChannel().send(PacketDistributor.ALL.noArg(), pMessage);
    }

    public <MSG extends AlchemyPacket> void sendToNear(MSG pMessage, Level pLevel, BlockPos pBlockPos, double pRadius) {
        ResourceKey dimension = pLevel.m_46472_();
        double posX = pBlockPos.m_123341_();
        double posY = pBlockPos.m_123342_();
        double posZ = pBlockPos.m_123343_();
        this.getChannel().send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)posX, (double)posY, (double)posZ, (double)pRadius, (ResourceKey)dimension)), pMessage);
    }

    public <MSG extends AlchemyPacket> void sendToTrackingChunk(MSG pMessage, Level pLevel, BlockPos pBlockPos) {
        LevelChunk levelChunk = pLevel.m_46745_(pBlockPos);
        this.getChannel().send(PacketDistributor.TRACKING_CHUNK.with(() -> levelChunk), pMessage);
    }
}

