/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading;

import com.tom.trading.Platform;
import com.tom.trading.block.VendingMachineBlock;
import com.tom.trading.gui.VendingMachineConfigMenu;
import com.tom.trading.gui.VendingMachineTradingMenu;
import com.tom.trading.item.TagFilterItem;
import com.tom.trading.tile.VendingMachineBlockEntity;
import com.tom.trading.tile.VendingMachineBlockEntityBase;
import com.tom.trading.util.GameObject;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class Content {
    public static final GameObject<VendingMachineBlock> VENDING_MACHINE = Content.blockWithItem("vending_machine", VendingMachineBlock::new);
    public static final GameObject<TagFilterItem> TAG_FILTER = Platform.ITEMS.register("tag_filter", TagFilterItem::new);
    public static final GameObject.GameObjectBlockEntity<VendingMachineBlockEntityBase> VENDING_MACHINE_TILE = Content.blockEntity("vending_machine.tile", VendingMachineBlockEntity::new, VENDING_MACHINE);
    public static final GameObject<MenuType<VendingMachineTradingMenu>> VENDING_MACHINE_TRADING_MENU = Content.menu("vending_machine.menu_trading", VendingMachineTradingMenu::new);
    public static final GameObject<MenuType<VendingMachineConfigMenu>> VENDING_MACHINE_CONFIG_MENU = Content.menu("vending_machine.menu_config", VendingMachineConfigMenu::new);

    private static <B extends Block> GameObject<B> blockWithItem(String name, Supplier<B> create) {
        return Content.blockWithItem(name, create, b -> new BlockItem(b, new Item.Properties()));
    }

    private static <B extends Block, I extends Item> GameObject<B> blockWithItem(String name, Supplier<B> create, Function<Block, I> createItem) {
        GameObject re = Platform.BLOCKS.register(name, create);
        Content.item(name, () -> (Item)createItem.apply((Block)re.get()));
        return re;
    }

    private static <I extends Item> GameObject<I> item(String name, Supplier<I> fact) {
        return Platform.ITEMS.register(name, () -> Platform.addItemToTab((Item)fact.get()));
    }

    @SafeVarargs
    private static <BE extends BlockEntity> GameObject.GameObjectBlockEntity<BE> blockEntity(String name, BlockEntityType.BlockEntitySupplier<? extends BE> create, GameObject<? extends Block> ... blocks) {
        return Platform.BLOCK_ENTITY.registerBE(name, create, blocks);
    }

    private static <M extends AbstractContainerMenu> GameObject<MenuType<M>> menu(String name, MenuType.MenuSupplier<M> create) {
        return Platform.MENU_TYPE.register(name, () -> new MenuType(create, FeatureFlags.f_244377_));
    }

    public static void init() {
    }
}

