/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.gui;

import com.tom.trading.Content;
import com.tom.trading.gui.AbstractFilteredMenu;
import com.tom.trading.gui.PhantomSlot;
import com.tom.trading.gui.VendingMachineTradingMenu;
import com.tom.trading.network.NetworkHandler;
import com.tom.trading.tile.VendingMachineBlockEntityBase;
import com.tom.trading.util.BlockFaceDirection;
import com.tom.trading.util.DataSlots;
import com.tom.trading.util.IDataReceiver;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class VendingMachineConfigMenu
extends AbstractFilteredMenu
implements IDataReceiver {
    private VendingMachineBlockEntityBase machine;
    protected final Inventory pinv;
    public int inputCfg;
    public int outputCfg;
    public int autoCfg;
    public int matchNBT;
    public int creativeMode;
    public Runnable updateGui;

    public VendingMachineConfigMenu(int pContainerId, Inventory pPlayerInventory) {
        this(pContainerId, pPlayerInventory, (Container)new SimpleContainer(9), (Container)new SimpleContainer(9), (Container)new SimpleContainer(8));
        this.m_38895_(DataSlots.set(c -> {
            this.inputCfg = c;
        }).onUpdate(this::updateGui));
        this.m_38895_(DataSlots.set(c -> {
            this.outputCfg = c;
        }).onUpdate(this::updateGui));
        this.m_38895_(DataSlots.set(c -> {
            this.matchNBT = c;
        }));
        this.m_38895_(DataSlots.set(c -> {
            this.autoCfg = c;
        }).onUpdate(this::updateGui));
        this.m_38895_(DataSlots.set(c -> {
            this.creativeMode = c;
        }).onUpdate(this::updateGui));
    }

    public VendingMachineConfigMenu(int pContainerId, Inventory pPlayerInventory, VendingMachineBlockEntityBase machine) {
        this(pContainerId, pPlayerInventory, (Container)machine.getInputs(), (Container)machine.getOutputs(), (Container)machine.getConfig());
        this.machine = machine;
        this.m_38895_(DataSlots.get(machine::getInputSides));
        this.m_38895_(DataSlots.get(machine::getOutputSides));
        this.m_38895_(DataSlots.get(machine::getMatchNBT));
        this.m_38895_(DataSlots.get(machine::getAutoSides));
        this.m_38895_(DataSlots.get(() -> machine.isCreativeMode() ? 1 : 0));
    }

    private VendingMachineConfigMenu(int pContainerId, Inventory pPlayerInventory, Container input, Container output, final Container config) {
        super(Content.VENDING_MACHINE_CONFIG_MENU.get(), pContainerId, pPlayerInventory);
        int j;
        int i;
        this.pinv = pPlayerInventory;
        for (i = 0; i < 4; ++i) {
            this.m_38897_(new PhantomSlot(config, i, 8 + i % 2 * 18, 35 + i / 2 * 18));
        }
        for (i = 0; i < 4; ++i) {
            this.m_38897_(new PhantomSlot(config, i + 4, 76 + i % 2 * 18, 35 + i / 2 * 18));
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 4; ++j) {
                this.m_38897_(new Slot(input, j + i * 4, 8 + j * 18, 82 + i * 18){

                    public boolean m_5857_(ItemStack pStack) {
                        for (int i = 0; i < 4; ++i) {
                            ItemStack o = config.m_8020_(i + 4).m_41777_();
                            if (!VendingMachineConfigMenu.this.compareItemStack(o, pStack, i + 4)) continue;
                            return true;
                        }
                        return false;
                    }
                });
            }
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 4; ++j) {
                this.m_38897_(new Slot(output, j + i * 4, 98 + j * 18, 82 + i * 18){

                    public boolean m_5857_(ItemStack pStack) {
                        return false;
                    }
                });
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)pPlayerInventory, j + i * 9 + 9, 8 + j * 18, 129 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)pPlayerInventory, k, 8 + k * 18, 187));
        }
    }

    public boolean compareItemStack(ItemStack pStack, ItemStack pOther, int slot) {
        if ((this.matchNBT & 1 << slot) != 0) {
            return ItemStack.m_150942_((ItemStack)pStack, (ItemStack)pOther);
        }
        return ItemStack.m_41656_((ItemStack)pStack, (ItemStack)pOther);
    }

    @Override
    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot instanceof PhantomSlot) {
            slot.m_5852_(ItemStack.f_41583_);
            return ItemStack.f_41583_;
        }
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (pIndex >= 8 && pIndex < 26) {
                if (!this.m_38903_(itemstack1, 26, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
            } else if (pIndex >= 26) {
                boolean in = false;
                for (int i = 0; i < 4; ++i) {
                    ItemStack o = ((Slot)this.f_38839_.get(i + 4)).m_7993_().m_41777_();
                    if (!this.compareItemStack(o, slot.m_7993_(), i + 4)) continue;
                    in = true;
                    break;
                }
                if (!in) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(itemstack1, 8, 17, false)) {
                    return ItemStack.f_41583_;
                }
            }
        }
        return itemstack;
    }

    public boolean m_6875_(Player pPlayer) {
        return this.machine != null ? this.machine.isInRange(pPlayer) && this.machine.canAccess(pPlayer) : true;
    }

    @Override
    public void m_150399_(int slotId, int dragType, ClickType pClickType, Player pPlayer) {
        Slot slot;
        Slot slot2 = slot = slotId > -1 && slotId < this.f_38839_.size() ? (Slot)this.f_38839_.get(slotId) : null;
        if (slot instanceof PhantomSlot) {
            slot.m_5852_(this.m_142621_().m_41777_());
            return;
        }
        super.m_150399_(slotId, dragType, pClickType, pPlayer);
    }

    public boolean m_6366_(Player pPlayer, int pId) {
        if (pId == 64) {
            pPlayer.m_5893_(new MenuProvider(){

                public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
                    return new VendingMachineTradingMenu(pContainerId, pPlayerInventory, VendingMachineConfigMenu.this.machine);
                }

                public Component m_5446_() {
                    return VendingMachineConfigMenu.this.machine.m_5446_();
                }
            });
            return true;
        }
        if ((pId & 0xE0) == 32) {
            if (pPlayer.m_150110_().f_35937_) {
                this.machine.setCreativeMode((pId & 1) != 0);
            }
        } else if ((pId & 0xE0) == 96) {
            int slot = pId & 0xF;
            boolean c = (pId & 0x10) != 0;
            this.machine.setMatchNBT(slot, c);
            return true;
        }
        return false;
    }

    @Override
    public void receive(CompoundTag tag) {
        Slot slot;
        int slotId;
        CompoundTag t;
        if (this.pinv.f_35978_.m_5833_()) {
            return;
        }
        if (tag.m_128441_("setItemCount")) {
            t = tag.m_128469_("setItemCount");
            slotId = t.m_128451_("id");
            byte count = t.m_128445_("count");
            Slot slot2 = slot = slotId > -1 && slotId < this.f_38839_.size() ? (Slot)this.f_38839_.get(slotId) : null;
            if (slot instanceof PhantomSlot) {
                ItemStack s = slot.m_7993_().m_41777_();
                s.m_41764_((int)count);
                slot.m_5852_(s);
            }
        }
        if (tag.m_128441_("setName")) {
            this.machine.setCustomName((Component)Component.m_237113_((String)tag.m_128461_("setName")));
        }
        if (tag.m_128441_("setPhantom")) {
            t = tag.m_128469_("setPhantom");
            slotId = t.m_128451_("id");
            ItemStack item = ItemStack.m_41712_((CompoundTag)t.m_128469_("item"));
            Slot slot3 = slot = slotId > -1 && slotId < this.f_38839_.size() ? (Slot)this.f_38839_.get(slotId) : null;
            if (slot instanceof PhantomSlot && !item.m_41619_()) {
                item.m_41764_(1);
                slot.m_5852_(item);
            }
        }
        if (tag.m_128441_("setSide")) {
            byte side = tag.m_128445_("setSide");
            byte mode = tag.m_128445_("mode");
            boolean auto = tag.m_128471_("auto");
            this.machine.setSides(side, mode, auto);
        }
    }

    public void setConfigCount(Slot slot, int count) {
        CompoundTag tag = new CompoundTag();
        CompoundTag t = new CompoundTag();
        tag.m_128365_("setItemCount", (Tag)t);
        t.m_128405_("id", slot.f_40219_);
        t.m_128344_("count", (byte)count);
        NetworkHandler.sendDataToServer(tag);
    }

    public void setName(String name) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("setName", name);
        NetworkHandler.sendDataToServer(tag);
    }

    public void setSides(BlockFaceDirection dir, int newState, boolean auto) {
        CompoundTag tag = new CompoundTag();
        tag.m_128344_("setSide", (byte)dir.ordinal());
        tag.m_128344_("mode", (byte)newState);
        tag.m_128379_("auto", auto);
        NetworkHandler.sendDataToServer(tag);
    }

    private void updateGui() {
        if (this.updateGui != null) {
            this.updateGui.run();
        }
    }
}

