/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.tile;

import com.tom.trading.tile.VendingMachineBlockEntityBase;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VendingMachineBlockEntity
extends VendingMachineBlockEntityBase {
    private EnumMap<Direction, LazyOptional<IItemHandler>> itemCaps = new EnumMap(Direction.class);
    private InvWrapper inputWr = new InvWrapper((Container)this.getInputs());
    private InvWrapper outputWr = new InvWrapper((Container)this.getOutputs());

    public VendingMachineBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(pPos, pBlockState);
        for (Direction d : Direction.values()) {
            this.itemCaps.put(d, (LazyOptional<IItemHandler>)LazyOptional.of(() -> new Handler(d)));
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return LazyOptional.empty();
            }
            return this.itemCaps.get(side).cast();
        }
        return super.getCapability(cap, side);
    }

    public void pullItemsFrom(BlockPos r, Direction d) {
        IItemHandler cap;
        BlockEntity side = this.f_58857_.m_7702_(r);
        if (side != null && (cap = (IItemHandler)side.getCapability(ForgeCapabilities.ITEM_HANDLER, d).orElse(null)) != null) {
            for (int i = 0; i < cap.getSlots(); ++i) {
                ItemStack ins;
                ItemStack ex;
                ItemStack item = cap.getStackInSlot(i);
                if (!this.canInputItem(item) || (ex = cap.extractItem(i, item.m_41613_(), true)).m_41619_() || !(ins = this.attempInsert(ex, (IItemHandler)this.inputWr, true)).m_41619_() && ins.m_41613_() == ex.m_41613_()) continue;
                ex = cap.extractItem(i, item.m_41613_() - ins.m_41613_(), false);
                ins = this.attempInsert(ex, (IItemHandler)this.inputWr, false);
                return;
            }
        }
    }

    private ItemStack attempInsert(ItemStack stack, IItemHandler d, boolean simulate) {
        ItemStack is = stack.m_41777_();
        for (int i = 0; i < d.getSlots(); ++i) {
            ItemStack res = d.insertItem(i, is, simulate);
            if (res.m_41619_()) {
                return ItemStack.f_41583_;
            }
            res = is;
        }
        return is;
    }

    public void pushItemsTo(BlockPos r, Direction d) {
        IItemHandler cap;
        BlockEntity side = this.f_58857_.m_7702_(r);
        if (side != null && (cap = (IItemHandler)side.getCapability(ForgeCapabilities.ITEM_HANDLER, d).orElse(null)) != null) {
            for (int i = 0; i < this.outputWr.getSlots(); ++i) {
                ItemStack ins;
                ItemStack item = this.outputWr.getStackInSlot(i);
                if (item.m_41619_() || !(ins = this.attempInsert(item, cap, true)).m_41619_() && ins.m_41613_() == item.m_41613_()) continue;
                ItemStack ex = this.outputWr.extractItem(i, item.m_41613_() - ins.m_41613_(), false);
                ins = this.attempInsert(ex, cap, false);
                return;
            }
        }
    }

    public class Handler
    implements IItemHandler {
        private final Direction dir;

        public Handler(Direction dir) {
            this.dir = dir;
        }

        public int getSlots() {
            return VendingMachineBlockEntity.this.inputWr.getSlots() + VendingMachineBlockEntity.this.outputWr.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return slot < VendingMachineBlockEntity.this.inputWr.getSlots() ? VendingMachineBlockEntity.this.inputWr.getStackInSlot(slot) : VendingMachineBlockEntity.this.outputWr.getStackInSlot(slot - VendingMachineBlockEntity.this.inputWr.getSlots());
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (slot >= VendingMachineBlockEntity.this.inputWr.getSlots() || !VendingMachineBlockEntity.this.canInput(stack, this.dir)) {
                return stack;
            }
            return VendingMachineBlockEntity.this.inputWr.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot < VendingMachineBlockEntity.this.inputWr.getSlots() || !VendingMachineBlockEntity.this.canOutput(this.dir)) {
                return ItemStack.f_41583_;
            }
            return VendingMachineBlockEntity.this.outputWr.extractItem(slot - VendingMachineBlockEntity.this.inputWr.getSlots(), amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return slot < VendingMachineBlockEntity.this.inputWr.getSlots() && VendingMachineBlockEntity.this.canInput(stack, this.dir);
        }
    }
}

